/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.stream;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.swizzle.stream.DelimitedTokenReplacementInputStream;
import org.codehaus.swizzle.stream.FixedTokenReplacementInputStream;
import org.codehaus.swizzle.stream.PushbackInputStream;
import org.codehaus.swizzle.stream.StringTokenHandler;
import org.codehaus.swizzle.stream.TruncateInputStream;

public class StreamLexer {
    private static final int MARK_BUF_SIZE = 512;
    private final InputStream delegate;
    private PushbackInputStream in;

    public StreamLexer(InputStream delegate) {
        this.delegate = delegate;
        this.in = new PushbackInputStream(delegate);
    }

    public String readToken(String begin, String end) throws Exception {
        return this.read(begin, end);
    }

    public String readToken(String string) throws Exception {
        return this.read(string);
    }

    public String read(String begin, String end) throws IOException {
        final String[] token = new String[]{null};
        DelimitedTokenReplacementInputStream search = new DelimitedTokenReplacementInputStream(this.in, begin, end, new StringTokenHandler(){

            public String handleToken(String string) throws IOException {
                token[0] = string;
                return string;
            }
        });
        int i = ((InputStream)search).read();
        while (i != -1 && token[0] == null) {
            i = ((InputStream)search).read();
        }
        return token[0];
    }

    public String read(String string) throws IOException {
        final String[] token = new String[]{null};
        FixedTokenReplacementInputStream search = new FixedTokenReplacementInputStream(this.in, string, new StringTokenHandler(){

            public String handleToken(String string11) throws IOException {
                token[0] = string11;
                return string11;
            }
        });
        int i = ((InputStream)search).read();
        while (i != -1 && token[0] == null) {
            i = ((InputStream)search).read();
        }
        return token[0];
    }

    public String seek(String begin, String end) throws IOException {
        this.in.mark(512);
        String value = this.read(begin, end);
        if (value == null) {
            this.in.reset();
        } else {
            this.in.unmark();
        }
        return value;
    }

    public String seek(String string) throws IOException {
        this.in.mark(512);
        String value = this.read(string);
        if (value == null) {
            this.in.reset();
        } else {
            this.in.unmark();
        }
        return value;
    }

    public String peek(String begin, String end) throws IOException {
        this.in.mark(512);
        String value = this.read(begin, end);
        this.in.reset();
        return value;
    }

    public String peek(String string) throws IOException {
        this.in.mark(512);
        String value = this.read(string);
        this.in.reset();
        return value;
    }

    public StreamLexer mark() throws IOException {
        return this.mark(null);
    }

    public void unmark() {
        if (this.in.getDelegate() == this.delegate) {
            throw new IllegalStateException("mark has not been set");
        }
        byte[] buf = this.in.getBuffer();
        this.in = (PushbackInputStream)this.in.getDelegate();
        this.in.unread(buf);
    }

    public StreamLexer mark(String limit) throws IOException {
        this.in = limit != null ? new TruncateInputStream(this.in, limit) : new PushbackInputStream(this.in);
        return this;
    }

    public boolean readAndMark(String begin, String end) throws IOException {
        if (this.read(begin) != null) {
            this.mark(end);
            return true;
        }
        return false;
    }

    public boolean seekAndMark(String begin, String end) throws IOException {
        if (this.seek(begin) != null) {
            this.mark(end);
            return true;
        }
        return false;
    }

    public boolean readAndUnmark() throws IOException {
        boolean found;
        if (this.in instanceof TruncateInputStream) {
            TruncateInputStream truncateInputStream = (TruncateInputStream)this.in;
            found = this.read(truncateInputStream.getEndToken()) != null;
        } else {
            this.in.skip(Long.MAX_VALUE);
            found = true;
        }
        this.unmark();
        return found;
    }

    public boolean seekAndUnmark() throws IOException {
        TruncateInputStream truncateInputStream;
        boolean found = this.in instanceof TruncateInputStream ? this.seek((truncateInputStream = (TruncateInputStream)this.in).getEndToken()) != null : true;
        this.unmark();
        return found;
    }
}

