/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.validation;

import com.ctc.wstx.msv.W3CSchema;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.grammar.xmlschema.XMLSchemaSchema;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.State;
import com.sun.msv.reader.xmlschema.EmbeddedSchema;
import com.sun.msv.reader.xmlschema.MultiSchemaReader;
import com.sun.msv.reader.xmlschema.SchemaState;
import com.sun.msv.reader.xmlschema.WSDLGrammarReaderController;
import com.sun.msv.reader.xmlschema.XMLSchemaReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Locator;

public class W3CMultiSchemaFactory {
    private MultiSchemaReader multiSchemaReader;
    private SAXParserFactory parserFactory;
    private RecursiveAllowedXMLSchemaReader xmlSchemaReader;
    private final Constructor<?> w3cSchemaConstructor = W3CSchema.class.getConstructor(XMLSchemaGrammar.class);

    public XMLValidationSchema createSchema(String baseURI, Map<String, Source> schemaSources) throws XMLStreamException {
        HashMap<String, EmbeddedSchema> embeddedSources = new HashMap<String, EmbeddedSchema>();
        for (Map.Entry<String, Source> source : schemaSources.entrySet()) {
            if (!(source.getValue() instanceof DOMSource)) continue;
            Node nd = ((DOMSource)source.getValue()).getNode();
            Element el = null;
            if (nd instanceof Element) {
                el = (Element)nd;
            } else if (nd instanceof Document) {
                el = ((Document)nd).getDocumentElement();
            }
            embeddedSources.put(source.getKey(), new EmbeddedSchema(source.getValue().getSystemId(), el));
        }
        this.parserFactory = SAXParserFactory.newInstance();
        this.parserFactory.setNamespaceAware(true);
        WSDLGrammarReaderController ctrl = new WSDLGrammarReaderController(null, baseURI, embeddedSources);
        this.xmlSchemaReader = new RecursiveAllowedXMLSchemaReader((GrammarReaderController)ctrl, this.parserFactory);
        this.multiSchemaReader = new MultiSchemaReader((XMLSchemaReader)this.xmlSchemaReader);
        for (Source source : schemaSources.values()) {
            this.multiSchemaReader.parse(source);
        }
        XMLSchemaGrammar grammar = this.multiSchemaReader.getResult();
        if (grammar == null) {
            throw new XMLStreamException("Failed to load schemas");
        }
        try {
            return (XMLValidationSchema)this.w3cSchemaConstructor.newInstance(grammar);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new XMLStreamException(e);
        }
    }

    static class RecursiveAllowedXMLSchemaReader
    extends XMLSchemaReader {
        Set<String> sysIds = new TreeSet<String>();

        RecursiveAllowedXMLSchemaReader(GrammarReaderController controller, SAXParserFactory parserFactory) {
            super(controller, parserFactory, new XMLSchemaReader.StateFactory(){

                public State schemaHead(String expectedNamespace) {
                    return new SchemaState(expectedNamespace){
                        private XMLSchemaSchema old;

                        protected void endSelf() {
                            super.endSelf();
                            RecursiveAllowedXMLSchemaReader r = (RecursiveAllowedXMLSchemaReader)this.reader;
                            r.currentSchema = this.old;
                        }

                        protected void onTargetNamespaceResolved(String targetNs, boolean ignoreContents) {
                            RecursiveAllowedXMLSchemaReader r = (RecursiveAllowedXMLSchemaReader)this.reader;
                            this.old = r.currentSchema;
                            r.currentSchema = r.getOrCreateSchema(targetNs);
                            if (ignoreContents) {
                                return;
                            }
                            if (!r.isSchemaDefined(r.currentSchema)) {
                                r.markSchemaAsDefined(r.currentSchema);
                            }
                        }
                    };
                }
            }, new ExpressionPool());
        }

        public void setLocator(Locator locator) {
            if (locator == null && this.getLocator() != null && this.getLocator().getSystemId() != null) {
                this.sysIds.add(this.getLocator().getSystemId());
            }
            super.setLocator(locator);
        }

        public void switchSource(Source source, State newState) {
            String url = source.getSystemId();
            if (url != null && this.sysIds.contains(url)) {
                return;
            }
            super.switchSource(source, newState);
        }
    }
}

