/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tdigest;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.SpecialValueLayouts;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.common.positional.PositionalSegment;
import org.apache.datasketches.quantilescommon.QuantilesUtil;
import org.apache.datasketches.tdigest.BinarySearch;
import org.apache.datasketches.tdigest.Sort;

public final class TDigestDouble {
    public static final short DEFAULT_K = 200;
    private boolean reverseMerge_;
    private final short k_;
    private double minValue_;
    private double maxValue_;
    private final int centroidsCapacity_;
    private int numCentroids_;
    private final double[] centroidMeans_;
    private final long[] centroidWeights_;
    private long centroidsWeight_;
    private int numBuffered_;
    private final double[] bufferValues_;
    private static final int BUFFER_MULTIPLIER = 4;
    private static final byte PREAMBLE_LONGS_EMPTY_OR_SINGLE = 1;
    private static final byte PREAMBLE_LONGS_MULTIPLE = 2;
    private static final byte SERIAL_VERSION = 1;
    private static final int COMPAT_DOUBLE = 1;
    private static final int COMPAT_FLOAT = 2;

    public TDigestDouble() {
        this(200);
    }

    public TDigestDouble(short k) {
        this(false, k, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, null, null, 0L, null);
    }

    public short getK() {
        return this.k_;
    }

    public void update(double value) {
        if (Double.isNaN(value)) {
            return;
        }
        if (this.numBuffered_ == this.centroidsCapacity_ * 4) {
            this.compress();
        }
        this.bufferValues_[this.numBuffered_] = value;
        ++this.numBuffered_;
        this.minValue_ = Math.min(this.minValue_, value);
        this.maxValue_ = Math.max(this.maxValue_, value);
    }

    public void merge(TDigestDouble other) {
        if (other.isEmpty()) {
            return;
        }
        int num = this.numCentroids_ + this.numBuffered_ + other.numCentroids_ + other.numBuffered_;
        double[] values = new double[num];
        long[] weights = new long[num];
        System.arraycopy(this.bufferValues_, 0, values, 0, this.numBuffered_);
        Arrays.fill(weights, 0, this.numBuffered_, 1L);
        System.arraycopy(other.bufferValues_, 0, values, this.numBuffered_, other.numBuffered_);
        Arrays.fill(weights, this.numBuffered_, this.numBuffered_ + other.numBuffered_, 1L);
        System.arraycopy(other.centroidMeans_, 0, values, this.numBuffered_ + other.numBuffered_, other.numCentroids_);
        System.arraycopy(other.centroidWeights_, 0, weights, this.numBuffered_ + other.numBuffered_, other.numCentroids_);
        this.merge(values, weights, (long)this.numBuffered_ + other.getTotalWeight(), this.numBuffered_ + other.numBuffered_ + other.numCentroids_);
    }

    private void compress() {
        if (this.numBuffered_ == 0) {
            return;
        }
        int num = this.numBuffered_ + this.numCentroids_;
        double[] values = new double[num];
        long[] weights = new long[num];
        System.arraycopy(this.bufferValues_, 0, values, 0, this.numBuffered_);
        Arrays.fill(weights, 0, this.numBuffered_, 1L);
        this.merge(values, weights, this.numBuffered_, this.numBuffered_);
    }

    public boolean isEmpty() {
        return this.numCentroids_ == 0 && this.numBuffered_ == 0;
    }

    public double getMinValue() {
        if (this.isEmpty()) {
            throw new SketchesStateException("The sketch must not be empty for this operation. ");
        }
        return this.minValue_;
    }

    public double getMaxValue() {
        if (this.isEmpty()) {
            throw new SketchesStateException("The sketch must not be empty for this operation. ");
        }
        return this.maxValue_;
    }

    public long getTotalWeight() {
        return this.centroidsWeight_ + (long)this.numBuffered_;
    }

    public double getRank(double value) {
        if (this.isEmpty()) {
            throw new SketchesStateException("The sketch must not be empty for this operation. ");
        }
        if (Double.isNaN(value)) {
            throw new SketchesArgumentException("Operation is undefined for Nan");
        }
        if (value < this.minValue_) {
            return 0.0;
        }
        if (value > this.maxValue_) {
            return 1.0;
        }
        if (this.numCentroids_ + this.numBuffered_ == 1) {
            return 0.5;
        }
        this.compress();
        double firstMean = this.centroidMeans_[0];
        if (value < firstMean) {
            if (firstMean - this.minValue_ > 0.0) {
                if (value == this.minValue_) {
                    return 0.5 / (double)this.centroidsWeight_;
                }
                return 1.0 + (value - this.minValue_) / (firstMean - this.minValue_) * ((double)this.centroidWeights_[0] / 2.0 - 1.0);
            }
            return 0.0;
        }
        double lastMean = this.centroidMeans_[this.numCentroids_ - 1];
        if (value > lastMean) {
            if (this.maxValue_ - lastMean > 0.0) {
                if (value == this.maxValue_) {
                    return 1.0 - 0.5 / (double)this.centroidsWeight_;
                }
                return 1.0 - (1.0 + (this.maxValue_ - value) / (this.maxValue_ - lastMean) * ((double)this.centroidWeights_[this.numCentroids_ - 1] / 2.0 - 1.0)) / (double)this.centroidsWeight_;
            }
            return 1.0;
        }
        int lower = BinarySearch.lowerBound(this.centroidMeans_, 0, this.numCentroids_, value);
        if (lower == this.numCentroids_) {
            throw new SketchesStateException("lower == end in getRank()");
        }
        int upper = BinarySearch.upperBound(this.centroidMeans_, lower, this.numCentroids_, value);
        if (upper == 0) {
            throw new SketchesStateException("upper == begin in getRank()");
        }
        if (value < this.centroidMeans_[lower]) {
            --lower;
        }
        if (upper == this.numCentroids_ || this.centroidMeans_[upper - 1] >= value) {
            --upper;
        }
        double weightBelow = 0.0;
        int i = 0;
        while (i != lower) {
            weightBelow += (double)this.centroidWeights_[i++];
        }
        weightBelow += (double)this.centroidWeights_[lower] / 2.0;
        double weightDelta = 0.0;
        while (i != upper) {
            weightDelta += (double)this.centroidWeights_[i++];
        }
        weightDelta -= (double)this.centroidWeights_[lower] / 2.0;
        weightDelta += (double)this.centroidWeights_[upper] / 2.0;
        if (this.centroidMeans_[upper] - this.centroidMeans_[lower] > 0.0) {
            return (weightBelow + weightDelta * (value - this.centroidMeans_[lower]) / (this.centroidMeans_[upper] - this.centroidMeans_[lower])) / (double)this.centroidsWeight_;
        }
        return (weightBelow + weightDelta / 2.0) / (double)this.centroidsWeight_;
    }

    public double getQuantile(double rank) {
        if (this.isEmpty()) {
            throw new SketchesStateException("The sketch must not be empty for this operation. ");
        }
        if (Double.isNaN(rank)) {
            throw new SketchesArgumentException("Operation is undefined for Nan");
        }
        if (rank < 0.0 || rank > 1.0) {
            throw new SketchesArgumentException("Normalized rank must be within [0, 1]");
        }
        this.compress();
        if (this.numCentroids_ == 1) {
            return this.centroidMeans_[0];
        }
        double weight = rank * (double)this.centroidsWeight_;
        if (weight < 1.0) {
            return this.minValue_;
        }
        if (weight > (double)this.centroidsWeight_ - 1.0) {
            return this.maxValue_;
        }
        double firstWeight = this.centroidWeights_[0];
        if (firstWeight > 1.0 && weight < firstWeight / 2.0) {
            return this.minValue_ + (weight - 1.0) / (firstWeight / 2.0 - 1.0) * (this.centroidMeans_[0] - this.minValue_);
        }
        double lastWeight = this.centroidWeights_[this.numCentroids_ - 1];
        if (lastWeight > 1.0 && (double)this.centroidsWeight_ - weight <= lastWeight / 2.0) {
            return this.maxValue_ + ((double)this.centroidsWeight_ - weight - 1.0) / (lastWeight / 2.0 - 1.0) * (this.maxValue_ - this.centroidMeans_[this.numCentroids_ - 1]);
        }
        double weightSoFar = firstWeight / 2.0;
        for (int i = 0; i < this.numCentroids_ - 1; ++i) {
            double dw = (double)(this.centroidWeights_[i] + this.centroidWeights_[i + 1]) / 2.0;
            if (weightSoFar + dw > weight) {
                double leftWeight = 0.0;
                if (this.centroidWeights_[i] == 1L) {
                    if (weight - weightSoFar < 0.5) {
                        return this.centroidMeans_[i];
                    }
                    leftWeight = 0.5;
                }
                double rightWeight = 0.0;
                if (this.centroidWeights_[i + 1] == 1L) {
                    if (weightSoFar + dw - weight <= 0.5) {
                        return this.centroidMeans_[i + 1];
                    }
                    rightWeight = 0.5;
                }
                double w1 = weight - weightSoFar - leftWeight;
                double w2 = weightSoFar + dw - weight - rightWeight;
                return TDigestDouble.weightedAverage(this.centroidMeans_[i], w1, this.centroidMeans_[i + 1], w2);
            }
            weightSoFar += dw;
        }
        double w1 = weight - (double)this.centroidsWeight_ - (double)this.centroidWeights_[this.numCentroids_ - 1] / 2.0;
        double w2 = (double)this.centroidWeights_[this.numCentroids_ - 1] / 2.0 - w1;
        return TDigestDouble.weightedAverage(this.centroidMeans_[this.numCentroids_ - 1], w1, this.maxValue_, w2);
    }

    public double[] getPMF(double[] splitPoints) {
        double[] buckets = this.getCDF(splitPoints);
        int i = buckets.length;
        while (i-- > 1) {
            int n = i;
            buckets[n] = buckets[n] - buckets[i - 1];
        }
        return buckets;
    }

    public double[] getCDF(double[] splitPoints) {
        if (this.isEmpty()) {
            throw new SketchesStateException("The sketch must not be empty for this operation. ");
        }
        QuantilesUtil.checkDoublesSplitPointsOrder(splitPoints);
        int len = splitPoints.length + 1;
        double[] ranks = new double[len];
        for (int i = 0; i < len - 1; ++i) {
            ranks[i] = this.getRank(splitPoints[i]);
        }
        ranks[len - 1] = 1.0;
        return ranks;
    }

    int getSerializedSizeBytes() {
        this.compress();
        return this.getPreambleLongs() * 8 + (this.isEmpty() ? 0 : (this.isSingleValue() ? 8 : 16 + 16 * this.numCentroids_));
    }

    public byte[] toByteArray() {
        this.compress();
        byte[] bytes = new byte[this.getSerializedSizeBytes()];
        PositionalSegment posSeg = PositionalSegment.wrap(MemorySegment.ofArray(bytes));
        posSeg.setByte((byte)this.getPreambleLongs());
        posSeg.setByte((byte)1);
        posSeg.setByte((byte)Family.TDIGEST.getID());
        posSeg.setShort(this.k_);
        posSeg.setByte((byte)((this.isEmpty() ? 1 << Flags.IS_EMPTY.ordinal() : 0) | (this.isSingleValue() ? 1 << Flags.IS_SINGLE_VALUE.ordinal() : 0) | (this.reverseMerge_ ? 1 << Flags.REVERSE_MERGE.ordinal() : 0)));
        posSeg.setShort((short)0);
        if (this.isEmpty()) {
            return bytes;
        }
        if (this.isSingleValue()) {
            posSeg.setDouble(this.minValue_);
            return bytes;
        }
        posSeg.setInt(this.numCentroids_);
        posSeg.setInt(0);
        posSeg.setDouble(this.minValue_);
        posSeg.setDouble(this.maxValue_);
        for (int i = 0; i < this.numCentroids_; ++i) {
            posSeg.setDouble(this.centroidMeans_[i]);
            posSeg.setLong(this.centroidWeights_[i]);
        }
        return bytes;
    }

    public static TDigestDouble heapify(MemorySegment seg) {
        return TDigestDouble.heapify(seg, false);
    }

    public static TDigestDouble heapify(MemorySegment seg, boolean isFloat) {
        double max;
        double min;
        boolean reverseMerge;
        byte expectedPreambleLongs;
        PositionalSegment posSeg = PositionalSegment.wrap(seg);
        byte preambleLongs = posSeg.getByte();
        byte serialVersion = posSeg.getByte();
        byte sketchType = posSeg.getByte();
        if (sketchType != (byte)Family.TDIGEST.getID()) {
            if (preambleLongs == 0 && serialVersion == 0 && sketchType == 0) {
                return TDigestDouble.heapifyCompat(seg);
            }
            throw new SketchesArgumentException("Sketch type mismatch: expected " + Family.TDIGEST.getID() + ", actual " + sketchType);
        }
        if (serialVersion != 1) {
            throw new SketchesArgumentException("Serial version mismatch: expected 1, actual " + serialVersion);
        }
        short k = posSeg.getShort();
        byte flagsByte = posSeg.getByte();
        boolean isEmpty = (flagsByte & 1 << Flags.IS_EMPTY.ordinal()) > 0;
        boolean isSingleValue = (flagsByte & 1 << Flags.IS_SINGLE_VALUE.ordinal()) > 0;
        byte by = expectedPreambleLongs = isEmpty || isSingleValue ? (byte)1 : 2;
        if (preambleLongs != expectedPreambleLongs) {
            throw new SketchesArgumentException("Preamble longs mismatch: expected " + expectedPreambleLongs + ", actual " + preambleLongs);
        }
        posSeg.getShort();
        if (isEmpty) {
            return new TDigestDouble(k);
        }
        boolean bl = reverseMerge = (flagsByte & 1 << Flags.REVERSE_MERGE.ordinal()) > 0;
        if (isSingleValue) {
            double value = isFloat ? (double)posSeg.getFloat() : posSeg.getDouble();
            return new TDigestDouble(reverseMerge, k, value, value, new double[]{value}, new long[]{1L}, 1L, null);
        }
        int numCentroids = posSeg.getInt();
        posSeg.getInt();
        if (isFloat) {
            min = posSeg.getFloat();
            max = posSeg.getFloat();
        } else {
            min = posSeg.getDouble();
            max = posSeg.getDouble();
        }
        double[] means = new double[numCentroids];
        long[] weights = new long[numCentroids];
        long totalWeight = 0L;
        for (int i = 0; i < numCentroids; ++i) {
            means[i] = isFloat ? (double)posSeg.getFloat() : posSeg.getDouble();
            weights[i] = isFloat ? (long)posSeg.getInt() : posSeg.getLong();
            totalWeight += weights[i];
        }
        return new TDigestDouble(reverseMerge, k, min, max, means, weights, totalWeight, null);
    }

    private static TDigestDouble heapifyCompat(MemorySegment seg) {
        int offset = 0;
        int type = seg.get(SpecialValueLayouts.JAVA_INT_UNALIGNED_BIG_ENDIAN, (long)offset);
        offset += 4;
        if (type != 1 && type != 2) {
            throw new SketchesArgumentException("unexpected compatibility type " + type);
        }
        if (type == 1) {
            double min = seg.get(SpecialValueLayouts.JAVA_DOUBLE_UNALIGNED_BIG_ENDIAN, (long)offset);
            double max = seg.get(SpecialValueLayouts.JAVA_DOUBLE_UNALIGNED_BIG_ENDIAN, (long)(offset += 8));
            short k = (short)seg.get(SpecialValueLayouts.JAVA_DOUBLE_UNALIGNED_BIG_ENDIAN, (long)(offset += 8));
            int numCentroids = seg.get(SpecialValueLayouts.JAVA_INT_UNALIGNED_BIG_ENDIAN, (long)(offset += 8));
            offset += 4;
            double[] means = new double[numCentroids];
            long[] weights = new long[numCentroids];
            long totalWeight = 0L;
            for (int i = 0; i < numCentroids; ++i) {
                weights[i] = (long)seg.get(SpecialValueLayouts.JAVA_DOUBLE_UNALIGNED_BIG_ENDIAN, (long)offset);
                means[i] = seg.get(SpecialValueLayouts.JAVA_DOUBLE_UNALIGNED_BIG_ENDIAN, (long)(offset += 8));
                offset += 8;
                totalWeight += weights[i];
            }
            return new TDigestDouble(false, k, min, max, means, weights, totalWeight, null);
        }
        double min = seg.get(SpecialValueLayouts.JAVA_DOUBLE_UNALIGNED_BIG_ENDIAN, (long)offset);
        double max = seg.get(SpecialValueLayouts.JAVA_DOUBLE_UNALIGNED_BIG_ENDIAN, (long)(offset += 8));
        short k = (short)seg.get(SpecialValueLayouts.JAVA_FLOAT_UNALIGNED_BIG_ENDIAN, (long)(offset += 8));
        seg.get(SpecialValueLayouts.JAVA_INT_UNALIGNED_BIG_ENDIAN, (long)(offset += 4));
        int numCentroids = seg.get(SpecialValueLayouts.JAVA_SHORT_UNALIGNED_BIG_ENDIAN, (long)(offset += 4));
        offset += 2;
        double[] means = new double[numCentroids];
        long[] weights = new long[numCentroids];
        long totalWeight = 0L;
        for (int i = 0; i < numCentroids; ++i) {
            weights[i] = (long)seg.get(SpecialValueLayouts.JAVA_FLOAT_UNALIGNED_BIG_ENDIAN, (long)offset);
            means[i] = seg.get(SpecialValueLayouts.JAVA_FLOAT_UNALIGNED_BIG_ENDIAN, (long)(offset += 4));
            offset += 4;
            totalWeight += weights[i];
        }
        return new TDigestDouble(false, k, min, max, means, weights, totalWeight, null);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean printCentroids) {
        StringBuilder sb = new StringBuilder();
        sb.append("MergingDigest").append(Util.LS).append(" Compression: ").append(this.k_).append(Util.LS).append(" Centroids: ").append(this.numCentroids_).append(Util.LS).append(" Buffered: ").append(this.numBuffered_).append(Util.LS).append(" Centroids Capacity: ").append(this.centroidsCapacity_).append(Util.LS).append(" Buffer Capacity: ").append(this.centroidsCapacity_ * 4).append(Util.LS).append("Centroids Weight: ").append(this.centroidsWeight_).append(Util.LS).append(" Total Weight: ").append(this.getTotalWeight()).append(Util.LS).append(" Reverse Merge: ").append(this.reverseMerge_).append(Util.LS);
        if (!this.isEmpty()) {
            sb.append(" Min: ").append(this.minValue_).append(Util.LS).append(" Max: ").append(this.maxValue_).append(Util.LS);
        }
        if (printCentroids) {
            int i;
            if (this.numCentroids_ > 0) {
                sb.append("Centroids:").append(Util.LS);
                for (i = 0; i < this.numCentroids_; ++i) {
                    sb.append(i).append(": ").append(this.centroidMeans_[i]).append(", ").append(this.centroidWeights_[i]).append(Util.LS);
                }
            }
            if (this.numBuffered_ > 0) {
                sb.append("Buffer:").append(Util.LS);
                for (i = 0; i < this.numBuffered_; ++i) {
                    sb.append(i).append(": ").append(this.bufferValues_[i]).append(Util.LS);
                }
            }
        }
        return sb.toString();
    }

    private TDigestDouble(boolean reverseMerge, short k, double min, double max, double[] means, long[] weights, long weight, double[] buffer) {
        this.reverseMerge_ = reverseMerge;
        this.k_ = k;
        this.minValue_ = min;
        this.maxValue_ = max;
        if (k < 10) {
            throw new SketchesArgumentException("k must be at least 10");
        }
        int fudge = k < 30 ? 30 : 10;
        this.centroidsCapacity_ = this.k_ * 2 + fudge;
        this.centroidMeans_ = new double[this.centroidsCapacity_];
        this.centroidWeights_ = new long[this.centroidsCapacity_];
        this.bufferValues_ = new double[this.centroidsCapacity_ * 4];
        this.numCentroids_ = 0;
        this.numBuffered_ = 0;
        this.centroidsWeight_ = weight;
        if (means != null && weights != null) {
            System.arraycopy(means, 0, this.centroidMeans_, 0, means.length);
            System.arraycopy(weights, 0, this.centroidWeights_, 0, weights.length);
            this.numCentroids_ = means.length;
        }
        if (buffer != null) {
            System.arraycopy(buffer, 0, this.bufferValues_, 0, buffer.length);
            this.numBuffered_ = buffer.length;
        }
    }

    private void merge(double[] values, long[] weights, long weight, int num) {
        System.arraycopy(this.centroidMeans_, 0, values, num, this.numCentroids_);
        System.arraycopy(this.centroidWeights_, 0, weights, num, this.numCentroids_);
        this.centroidsWeight_ += weight;
        this.numCentroids_ = 0;
        Sort.stableSort(values, weights, num += this.numCentroids_);
        if (this.reverseMerge_) {
            Sort.reverse(values, num);
            Sort.reverse(weights, num);
        }
        this.centroidMeans_[0] = values[0];
        this.centroidWeights_[0] = weights[0];
        ++this.numCentroids_;
        double weightSoFar = 0.0;
        for (int current = 1; current != num; ++current) {
            double proposedWeight = this.centroidWeights_[this.numCentroids_ - 1] + weights[current];
            boolean addThis = false;
            if (current != 1 && current != num - 1) {
                double q0 = weightSoFar / (double)this.centroidsWeight_;
                double q2 = (weightSoFar + proposedWeight) / (double)this.centroidsWeight_;
                double normalizer = ScaleFunction.normalizer(this.k_ * 2, this.centroidsWeight_);
                boolean bl = addThis = proposedWeight <= (double)this.centroidsWeight_ * Math.min(ScaleFunction.max(q0, normalizer), ScaleFunction.max(q2, normalizer));
            }
            if (addThis) {
                int n = this.numCentroids_ - 1;
                this.centroidWeights_[n] = this.centroidWeights_[n] + weights[current];
                int n2 = this.numCentroids_ - 1;
                this.centroidMeans_[n2] = this.centroidMeans_[n2] + (values[current] - this.centroidMeans_[this.numCentroids_ - 1]) * (double)weights[current] / (double)this.centroidWeights_[this.numCentroids_ - 1];
                continue;
            }
            weightSoFar += (double)this.centroidWeights_[this.numCentroids_ - 1];
            this.centroidMeans_[this.numCentroids_] = values[current];
            this.centroidWeights_[this.numCentroids_] = weights[current];
            ++this.numCentroids_;
        }
        if (this.reverseMerge_) {
            Sort.reverse(this.centroidMeans_, this.numCentroids_);
            Sort.reverse(this.centroidWeights_, this.numCentroids_);
        }
        this.numBuffered_ = 0;
        this.reverseMerge_ = !this.reverseMerge_;
        this.minValue_ = Math.min(this.minValue_, this.centroidMeans_[0]);
        this.maxValue_ = Math.max(this.maxValue_, this.centroidMeans_[this.numCentroids_ - 1]);
    }

    private boolean isSingleValue() {
        return this.getTotalWeight() == 1L;
    }

    private int getPreambleLongs() {
        return this.isEmpty() || this.isSingleValue() ? 1 : 2;
    }

    private static double weightedAverage(double x1, double w1, double x2, double w2) {
        return (x1 * w1 + x2 * w2) / (w1 + w2);
    }

    private static enum Flags {
        IS_EMPTY,
        IS_SINGLE_VALUE,
        REVERSE_MERGE;

    }

    private static final class ScaleFunction {
        private ScaleFunction() {
        }

        static double max(double q, double normalizer) {
            return q * (1.0 - q) / normalizer;
        }

        static double normalizer(double compression, double n) {
            return compression / ScaleFunction.z(compression, n);
        }

        static double z(double compression, double n) {
            return 4.0 * Math.log(n / compression) + 24.0;
        }
    }
}

