/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.pig.theta.PigUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class ErrorBounds
extends EvalFunc<Tuple> {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private final long seed_;

    public ErrorBounds() {
        this(9001L);
    }

    public ErrorBounds(String seedStr) {
        this(Long.parseLong(seedStr));
    }

    public ErrorBounds(long seed) {
        this.seed_ = seed;
    }

    public Tuple exec(Tuple sketchTuple) throws IOException {
        if (sketchTuple == null || sketchTuple.size() == 0) {
            return null;
        }
        Sketch sketch = PigUtil.tupleToSketch(sketchTuple, this.seed_);
        Tuple outputTuple = tupleFactory.newTuple(3);
        outputTuple.set(0, (Object)sketch.getEstimate());
        outputTuple.set(1, (Object)sketch.getUpperBound(2));
        outputTuple.set(2, (Object)sketch.getLowerBound(2));
        return outputTuple;
    }

    public Schema outputSchema(Schema input) {
        if (input != null) {
            try {
                Schema tupleSchema = new Schema();
                tupleSchema.add(new Schema.FieldSchema("Estimate", 25));
                tupleSchema.add(new Schema.FieldSchema("UpperBound", 25));
                tupleSchema.add(new Schema.FieldSchema("LowerBound", 25));
                return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
            }
            catch (FrontendException frontendException) {
                // empty catch block
            }
        }
        return null;
    }
}

