/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.servlet.impl.config;

import javax.enterprise.inject.Typed;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.exclude.Exclude;
import org.apache.deltaspike.core.impl.config.ConfigurationExtension;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.servlet.impl.config.ServletConfigSource;

@WebListener
@Typed
@Exclude
public class ServletConfigListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ConfigSource[] configSources;
        for (ConfigSource configSource : configSources = ConfigResolver.getConfigSources()) {
            if (!(configSource instanceof ServletConfigSource)) continue;
            this.setServletConfig((ServletConfigSource)configSource, sce);
            return;
        }
    }

    private void setServletConfig(ServletConfigSource configSource, ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (servletContextName != null && servletContextName.length() > 0) {
            String oldAppName = ConfigResolver.getPropertyValue((String)"deltaspike.application.name");
            ConfigurationExtension.unRegisterConfigMBean((String)oldAppName);
            configSource.setPropertyValue("deltaspike.application.name", servletContextName);
            ConfigurationExtension.registerConfigMBean();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

