/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.sp;

import java.util.List;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.sp.StoredProcEngine;
import org.apache.directory.server.core.api.sp.StoredProcEngineConfig;
import org.apache.directory.server.core.api.sp.StoredProcUtils;
import org.apache.directory.server.i18n.I18n;

public class StoredProcExecutionManager {
    private final String storedProcContainer;
    private final List<StoredProcEngineConfig> storedProcEngineConfigs;

    public StoredProcExecutionManager(String storedProcContainer, List<StoredProcEngineConfig> storedProcEngineConfigs) {
        this.storedProcContainer = storedProcContainer;
        this.storedProcEngineConfigs = storedProcEngineConfigs;
    }

    public Entry findStoredProcUnit(CoreSession session, String fullSPName) throws Exception {
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        controls.setSearchScope(2);
        String spUnitName = StoredProcUtils.extractStoredProcUnitName(fullSPName);
        AttributeType storeProcUnitNamAT = session.getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry("storedProcUnitName");
        EqualityNode filter = new EqualityNode(storeProcUnitNamAT, new Value(storeProcUnitNamAT, spUnitName));
        Dn dn = session.getDirectoryService().getDnFactory().create(this.storedProcContainer);
        Cursor<Entry> results = session.search(dn, SearchScope.SUBTREE, filter, AliasDerefMode.DEREF_ALWAYS, new String[0]);
        if (results.first()) {
            Entry entry = results.get();
            results.close();
            return entry;
        }
        return null;
    }

    public StoredProcEngine getStoredProcEngineInstance(Entry spUnitEntry) throws LdapException {
        String spLangId = ((ClonedServerEntry)spUnitEntry).getOriginalEntry().get("storedProcLangId").getString();
        for (StoredProcEngineConfig engineConfig : this.storedProcEngineConfigs) {
            StoredProcEngine engine;
            if (!engineConfig.getStoredProcLangId().equalsIgnoreCase(spLangId)) continue;
            Class<? extends StoredProcEngine> engineType = engineConfig.getStoredProcEngineType();
            try {
                engine = engineType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LdapException ne = new LdapException(e.getMessage(), e);
                ne.initCause(e);
                throw ne;
            }
            engine.setSPUnitEntry(((ClonedServerEntry)spUnitEntry).getOriginalEntry());
            return engine;
        }
        throw new LdapException(I18n.err(I18n.ERR_294, spLangId));
    }
}

