/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.util.Iterator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.evaluator.LeafEvaluator;

public class EqualityEvaluator<T>
extends LeafEvaluator<T> {
    public EqualityEvaluator(EqualityNode<T> node, Store db, SchemaManager schemaManager) throws LdapException {
        super(node, db, schemaManager);
        MatchingRule mr;
        if (db.hasIndexOn(this.attributeType)) {
            try {
                this.idx = db.getIndex(this.attributeType);
            }
            catch (IndexNotFoundException infe) {
                throw new LdapOtherException(infe.getMessage(), infe);
            }
        }
        if ((mr = this.attributeType.getEquality()) == null) {
            this.normalizer = new NoOpNormalizer(this.attributeType.getOid());
            this.ldapComparator = null;
        } else {
            this.normalizer = mr.getNormalizer();
            this.ldapComparator = mr.getLdapComparator();
        }
    }

    @Override
    public EqualityNode<T> getExpression() {
        return (EqualityNode)this.node;
    }

    @Override
    public boolean evaluate(PartitionTxn partitionTxn, IndexEntry<?, String> indexEntry) throws LdapException {
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(partitionTxn, indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        return this.evaluate(entry);
    }

    @Override
    public boolean evaluate(Entry entry) throws LdapException {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null && this.evaluate(attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(attr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evaluate(Attribute attribute) {
        if (attribute.contains(this.node.getValue())) {
            return true;
        }
        for (Value value : attribute) {
            byte[] nodeValue;
            String nodeValue2;
            String serverValue;
            if (!(value.isHumanReadable() ? (serverValue = value.getNormalized()).compareTo(nodeValue2 = this.node.getValue().getNormalized()) == 0 : value.compareTo(nodeValue = this.node.getValue().getBytes()) == 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("EqualityEvaluator : ").append(super.toString()).append('\n');
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

