/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime.assigner;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class PipeTsFileEpochProgressIndexKeeper {
    private final Map<String, Map<String, Map<String, TsFileResource>>> progressIndexKeeper = new ConcurrentHashMap<String, Map<String, Map<String, TsFileResource>>>();

    public synchronized void registerProgressIndex(String dataRegionId, String pipeName, TsFileResource resource) {
        this.progressIndexKeeper.computeIfAbsent(dataRegionId, k -> new ConcurrentHashMap()).computeIfAbsent(pipeName, k -> new ConcurrentHashMap()).putIfAbsent(resource.getTsFilePath(), resource);
    }

    public synchronized void eliminateProgressIndex(String dataRegionId, @Nonnull String pipeName, String filePath) {
        this.progressIndexKeeper.computeIfAbsent(dataRegionId, k -> new ConcurrentHashMap()).computeIfAbsent(pipeName, k -> new ConcurrentHashMap()).remove(filePath);
    }

    public synchronized boolean isProgressIndexAfterOrEquals(String dataRegionId, String pipeName, String tsFilePath, ProgressIndex progressIndex) {
        return this.progressIndexKeeper.computeIfAbsent(dataRegionId, k -> new ConcurrentHashMap()).computeIfAbsent(pipeName, k -> new ConcurrentHashMap()).entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), tsFilePath)).map(Map.Entry::getValue).filter(Objects::nonNull).anyMatch(resource -> !resource.getMaxProgressIndex().isAfter(progressIndex));
    }

    public static PipeTsFileEpochProgressIndexKeeper getInstance() {
        return PipeTimePartitionProgressIndexKeeperHolder.INSTANCE;
    }

    private PipeTsFileEpochProgressIndexKeeper() {
    }

    private static class PipeTimePartitionProgressIndexKeeperHolder {
        private static final PipeTsFileEpochProgressIndexKeeper INSTANCE = new PipeTsFileEpochProgressIndexKeeper();

        private PipeTimePartitionProgressIndexKeeperHolder() {
        }
    }
}

