/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.common.request;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;

public class DeserializedBatchIndexedConsensusRequest
implements IConsensusRequest,
Comparable<DeserializedBatchIndexedConsensusRequest> {
    private final long startSyncIndex;
    private final long endSyncIndex;
    private final List<IConsensusRequest> insertNodes;

    public DeserializedBatchIndexedConsensusRequest(long startSyncIndex, long endSyncIndex, int size) {
        this.startSyncIndex = startSyncIndex;
        this.endSyncIndex = endSyncIndex;
        this.insertNodes = new ArrayList<IConsensusRequest>(size);
    }

    public long getStartSyncIndex() {
        return this.startSyncIndex;
    }

    public long getEndSyncIndex() {
        return this.endSyncIndex;
    }

    public List<IConsensusRequest> getInsertNodes() {
        return this.insertNodes;
    }

    public void add(IConsensusRequest insertNode) {
        this.insertNodes.add(insertNode);
    }

    @Override
    public int compareTo(DeserializedBatchIndexedConsensusRequest o) {
        return Long.compare(this.startSyncIndex, o.startSyncIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeserializedBatchIndexedConsensusRequest request = (DeserializedBatchIndexedConsensusRequest)o;
        return this.startSyncIndex == request.startSyncIndex && this.endSyncIndex == request.endSyncIndex && Objects.equals(this.insertNodes, request.insertNodes);
    }

    public int hashCode() {
        return Objects.hash(this.startSyncIndex, this.endSyncIndex, this.insertNodes);
    }

    @Override
    public ByteBuffer serializeToByteBuffer() {
        return null;
    }
}

