/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class UnregisterNodesRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=564");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=566");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=565");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15197");
    private final RequestHeader requestHeader;
    private final NodeId[] nodesToUnregister;

    public UnregisterNodesRequest(RequestHeader requestHeader, NodeId[] nodesToUnregister) {
        this.requestHeader = requestHeader;
        this.nodesToUnregister = nodesToUnregister;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public NodeId[] getNodesToUnregister() {
        return this.nodesToUnregister;
    }

    protected UnregisterNodesRequest(UnregisterNodesRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((UnregisterNodesRequestBuilder)b).requestHeader;
        this.nodesToUnregister = ((UnregisterNodesRequestBuilder)b).nodesToUnregister;
    }

    public static UnregisterNodesRequestBuilder<?, ?> builder() {
        return new UnregisterNodesRequestBuilderImpl();
    }

    public UnregisterNodesRequestBuilder<?, ?> toBuilder() {
        return new UnregisterNodesRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnregisterNodesRequest)) {
            return false;
        }
        UnregisterNodesRequest other = (UnregisterNodesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getNodesToUnregister(), other.getNodesToUnregister());
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnregisterNodesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodesToUnregister());
        return result;
    }

    @Override
    public String toString() {
        return "UnregisterNodesRequest(requestHeader=" + this.getRequestHeader() + ", nodesToUnregister=" + Arrays.deepToString(this.getNodesToUnregister()) + ")";
    }

    private static final class UnregisterNodesRequestBuilderImpl
    extends UnregisterNodesRequestBuilder<UnregisterNodesRequest, UnregisterNodesRequestBuilderImpl> {
        private UnregisterNodesRequestBuilderImpl() {
        }

        @Override
        protected UnregisterNodesRequestBuilderImpl self() {
            return this;
        }

        @Override
        public UnregisterNodesRequest build() {
            return new UnregisterNodesRequest(this);
        }
    }

    public static abstract class UnregisterNodesRequestBuilder<C extends UnregisterNodesRequest, B extends UnregisterNodesRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private NodeId[] nodesToUnregister;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            UnregisterNodesRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(UnregisterNodesRequest instance, UnregisterNodesRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.nodesToUnregister(instance.nodesToUnregister);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B nodesToUnregister(NodeId[] nodesToUnregister) {
            this.nodesToUnregister = nodesToUnregister;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "UnregisterNodesRequest.UnregisterNodesRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", nodesToUnregister=" + Arrays.deepToString(this.nodesToUnregister) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<UnregisterNodesRequest> {
        @Override
        public Class<UnregisterNodesRequest> getType() {
            return UnregisterNodesRequest.class;
        }

        @Override
        public UnregisterNodesRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            NodeId[] nodesToUnregister = decoder.readNodeIdArray("NodesToUnregister");
            return new UnregisterNodesRequest(requestHeader, nodesToUnregister);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, UnregisterNodesRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeNodeIdArray("NodesToUnregister", value.getNodesToUnregister());
        }
    }
}

