/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class QuotaType {
    public static final QuotaType COUNT = QuotaType.of("count");
    public static final QuotaType SIZE = QuotaType.of("size");
    private final String value;

    public static QuotaType of(String value) {
        Preconditions.checkArgument(StringUtils.isNotBlank(value), "`value` is mandatory");
        return new QuotaType(value);
    }

    private QuotaType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaType) {
            QuotaType other = (QuotaType)o;
            return Objects.equals(this.value, other.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("value", this.value).toString();
    }
}

