/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.quota.search;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class QuotaBoundary {
    private final double ratio;

    public QuotaBoundary(double ratio) {
        this.ratio = ratio;
    }

    public double getRatio() {
        return ratio;
    }

    @Override
    public final boolean equals(Object o) {
        if (o instanceof QuotaBoundary) {
            QuotaBoundary that = (QuotaBoundary) o;

            return Objects.equals(this.ratio, that.ratio);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(ratio);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
            .add("ratio", ratio)
            .toString();
    }
}
