/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.reader;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufReader<T extends GeneratedMessageV3>
implements SchemaReader<T> {
    private Parser<T> tParser;
    private static final Logger log = LoggerFactory.getLogger(ProtobufReader.class);

    public ProtobufReader(T protoMessageInstance) {
        this.tParser = protoMessageInstance.getParserForType();
    }

    public T read(byte[] bytes, int offset, int length) {
        try {
            return (T)((GeneratedMessageV3)this.tParser.parseFrom(bytes, offset, length));
        }
        catch (InvalidProtocolBufferException e) {
            throw new SchemaSerializationException((Throwable)e);
        }
    }

    public T read(InputStream inputStream) {
        try {
            GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)this.tParser.parseFrom(inputStream);
            return (T)generatedMessageV3;
        }
        catch (InvalidProtocolBufferException e) {
            throw new SchemaSerializationException((Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("ProtobufReader close inputStream close error", (Throwable)e);
            }
        }
    }
}

