/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import jakarta.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRatio;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.quota.search.opensearch.json.QuotaRatioAsJson;

public class QuotaRatioToOpenSearchJson {
    private final QuotaRootResolver quotaRootResolver;
    private final ObjectMapper mapper;

    @Inject
    public QuotaRatioToOpenSearchJson(QuotaRootResolver quotaRootResolver) {
        this.quotaRootResolver = quotaRootResolver;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new Jdk8Module());
    }

    public String convertToJson(MailboxEvents.QuotaUsageUpdatedEvent event) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)QuotaRatioAsJson.builder().user(this.quotaRootResolver.associatedUsername(event.getQuotaRoot()).asString()).domain(event.getQuotaRoot().getDomain().map(Domain::asString)).quotaRatio(QuotaRatio.from((Quota)event.getSizeQuota(), (Quota)event.getCountQuota())).sizeLimit(((QuotaSizeLimit)event.getSizeQuota().getLimit()).asLongOptional()).countLimit(((QuotaCountLimit)event.getCountQuota().getLimit()).asLongOptional()).sizeUsed(((QuotaSizeUsage)event.getSizeQuota().getUsed()).asLong()).countUsed(((QuotaCountUsage)event.getCountQuota().getUsed()).asLong()).build());
    }
}

