/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicStringRangeArrayHeader;
import org.apache.juneau.internal.Cache;

@Header(value="Content-Disposition")
public class ContentDisposition
extends BasicStringRangeArrayHeader {
    private static final long serialVersionUID = 1L;
    private static final Cache<String, ContentDisposition> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);

    public static ContentDisposition of(String value) {
        if (value == null) {
            return null;
        }
        ContentDisposition x = CACHE.get(value);
        if (x == null) {
            x = CACHE.put(value, new ContentDisposition(value));
        }
        return x;
    }

    public static ContentDisposition of(Object value) {
        if (value == null) {
            return null;
        }
        return new ContentDisposition(value);
    }

    public static ContentDisposition of(Supplier<?> value) {
        if (value == null) {
            return null;
        }
        return new ContentDisposition(value);
    }

    public ContentDisposition(Object value) {
        super("Content-Disposition", value);
    }

    public ContentDisposition(String value) {
        this((Object)value);
    }
}

