/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ContextBuilder;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanAnnotation;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.transform.BeanInterceptor;

public class BeanContextBuilder
extends ContextBuilder {
    public BeanContextBuilder() {
    }

    public BeanContextBuilder(PropertyStore ps) {
        super(ps);
    }

    @Override
    public BeanContext build() {
        return this.build(BeanContext.class);
    }

    @FluentSetter
    public BeanContextBuilder annotations(Annotation ... values) {
        return this.prependTo("BeanContext.annotations.lo", values);
    }

    @FluentSetter
    public BeanContextBuilder beanClassVisibility(Visibility value) {
        return this.set("BeanContext.beanClassVisibility.s", (Object)value);
    }

    @FluentSetter
    public BeanContextBuilder beanConstructorVisibility(Visibility value) {
        return this.set("BeanContext.beanConstructorVisibility.s", (Object)value);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beanDictionary(Object ... values) {
        return this.prependTo("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beanDictionary(Class<?> ... values) {
        return this.prependTo("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beanDictionaryReplace(Class<?> ... values) {
        return this.set("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beanDictionaryReplace(Object ... values) {
        return this.set("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beanDictionaryRemove(Class<?> ... values) {
        return this.removeFrom("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beanDictionaryRemove(Object ... values) {
        return this.removeFrom("BeanContext.beanDictionary.lc", values);
    }

    @FluentSetter
    public BeanContextBuilder beanFieldVisibility(Visibility value) {
        return this.set("BeanContext.beanFieldVisibility.s", (Object)value);
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder beanFilters(Object ... values) {
        return this.prependTo("BeanContext.beanFilters.lo", values);
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder beanFiltersReplace(Object ... values) {
        return this.set("BeanContext.beanFilters.lo", values);
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder beanFiltersRemove(Object ... values) {
        return this.removeFrom("BeanContext.beanFilters.lo", values);
    }

    @FluentSetter
    public BeanContextBuilder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(on).interceptor(value));
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder beanMapPutReturnsOldValue(boolean value) {
        return this.set("BeanContext.beanMapPutReturnsOldValue.b", value);
    }

    @FluentSetter
    public BeanContextBuilder beanMapPutReturnsOldValue() {
        return this.set("BeanContext.beanMapPutReturnsOldValue.b", true);
    }

    @FluentSetter
    public BeanContextBuilder beanMethodVisibility(Visibility value) {
        return this.set("BeanContext.beanMethodVisibility.s", (Object)value);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beansRequireDefaultConstructor(boolean value) {
        return this.set("BeanContext.beansRequireDefaultConstructor.b", value);
    }

    @FluentSetter
    public BeanContextBuilder beansRequireDefaultConstructor() {
        return this.set("BeanContext.beansRequireDefaultConstructor.b", true);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beansRequireSerializable(boolean value) {
        return this.set("BeanContext.beansRequireSerializable.b", value);
    }

    @FluentSetter
    public BeanContextBuilder beansRequireSerializable() {
        return this.set("BeanContext.beansRequireSerializable.b", true);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beansRequireSettersForGetters(boolean value) {
        return this.set("BeanContext.beansRequireSettersForGetters.b", value);
    }

    @FluentSetter
    public BeanContextBuilder beansRequireSettersForGetters() {
        return this.set("BeanContext.beansRequireSettersForGetters.b", true);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder beansRequireSomeProperties(boolean value) {
        return this.set("BeanContext.beansRequireSomeProperties.b", value);
    }

    @FluentSetter
    public BeanContextBuilder beansDontRequireSomeProperties() {
        return this.set("BeanContext.beansRequireSomeProperties.b", false);
    }

    @FluentSetter
    public BeanContextBuilder bpi(Class<?> beanClass, String properties) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(beanClass.getName()).bpi(properties));
    }

    @FluentSetter
    public BeanContextBuilder bpi(Map<String, Object> values) {
        for (Map.Entry<String, Object> e : values.entrySet()) {
            this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(e.getKey()).bpi(StringUtils.stringify(e.getValue())));
        }
        return this;
    }

    @FluentSetter
    public BeanContextBuilder bpi(String beanClassName, String properties) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(beanClassName).bpi(properties));
    }

    @FluentSetter
    public BeanContextBuilder bpx(Class<?> beanClass, String properties) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(beanClass.getName()).bpx(properties));
    }

    @FluentSetter
    public BeanContextBuilder bpx(Map<String, Object> values) {
        for (Map.Entry<String, Object> e : values.entrySet()) {
            this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(e.getKey()).bpx(StringUtils.stringify(e.getValue())));
        }
        return this;
    }

    @FluentSetter
    public BeanContextBuilder bpx(String beanClassName, String properties) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(beanClassName).bpx(properties));
    }

    @FluentSetter
    public BeanContextBuilder bpro(Class<?> beanClass, String properties) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(beanClass.getName()).bpro(properties));
    }

    @FluentSetter
    public BeanContextBuilder bpro(Map<String, Object> values) {
        for (Map.Entry<String, Object> e : values.entrySet()) {
            this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(e.getKey()).bpro(StringUtils.stringify(e.getValue())));
        }
        return this;
    }

    @FluentSetter
    public BeanContextBuilder bpro(String beanClassName, String properties) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(beanClassName).bpro(properties));
    }

    @FluentSetter
    public BeanContextBuilder bpwo(Class<?> beanClass, String properties) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(beanClass.getName()).bpwo(properties));
    }

    @FluentSetter
    public BeanContextBuilder bpwo(Map<String, Object> values) {
        for (Map.Entry<String, Object> e : values.entrySet()) {
            this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(e.getKey()).bpwo(StringUtils.stringify(e.getValue())));
        }
        return this;
    }

    @FluentSetter
    public BeanContextBuilder bpwo(String beanClassName, String properties) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(beanClassName).bpwo(properties));
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder debug(boolean value) {
        return this.set("Context.debug.b", value);
    }

    @FluentSetter
    public BeanContextBuilder dictionary(Object ... values) {
        return this.prependTo("BeanContext.beanDictionary.lc", values);
    }

    @FluentSetter
    public BeanContextBuilder dictionaryOn(Class<?> on, Class<?> ... values) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(on).dictionary(values));
    }

    @FluentSetter
    public <T> BeanContextBuilder example(Class<T> pojoClass, T o) {
        return this.putTo("BeanContext.examples.smo", pojoClass.getName(), o);
    }

    @FluentSetter
    public <T> BeanContextBuilder exampleJson(Class<T> pojoClass, String json) {
        try {
            return this.putTo("BeanContext.examples.smo", pojoClass.getName(), SimpleJson.DEFAULT.read(json, pojoClass));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder excludeProperties(Class<?> beanClass, String properties) {
        return this.putTo("BeanContext.bpx.sms", beanClass.getName(), properties);
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder excludeProperties(Map<String, String> values) {
        return this.set("BeanContext.bpx.sms", values);
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder excludeProperties(String beanClassName, String value) {
        return this.putTo("BeanContext.bpx.sms", beanClassName, value);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder fluentSetters(boolean value) {
        return this.set("BeanContext.fluentSetters.b", value);
    }

    @FluentSetter
    public BeanContextBuilder fluentSetters() {
        return this.set("BeanContext.fluentSetters.b", true);
    }

    @FluentSetter
    public BeanContextBuilder fluentSetters(Class<?> on) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(on).fluentSetters(true));
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        return this.set("BeanContext.ignoreInvocationExceptionsOnGetters.b", value);
    }

    @FluentSetter
    public BeanContextBuilder ignoreInvocationExceptionsOnGetters() {
        return this.set("BeanContext.ignoreInvocationExceptionsOnGetters.b", true);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        return this.set("BeanContext.ignoreInvocationExceptionsOnSetters.b", value);
    }

    @FluentSetter
    public BeanContextBuilder ignoreInvocationExceptionsOnSetters() {
        return this.set("BeanContext.ignoreInvocationExceptionsOnSetters.b", true);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder ignorePropertiesWithoutSetters(boolean value) {
        return this.set("BeanContext.ignorePropertiesWithoutSetters.b", value);
    }

    @FluentSetter
    public BeanContextBuilder dontIgnorePropertiesWithoutSetters() {
        return this.set("BeanContext.ignorePropertiesWithoutSetters.b", false);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder ignoreTransientFields(boolean value) {
        return this.set("BeanContext.ignoreTransientFields.b", value);
    }

    @FluentSetter
    public BeanContextBuilder dontIgnoreTransientFields() {
        return this.set("BeanContext.ignoreTransientFields.b", false);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder ignoreUnknownBeanProperties(boolean value) {
        return this.set("BeanContext.ignoreUnknownBeanProperties.b", value);
    }

    @FluentSetter
    public BeanContextBuilder ignoreUnknownBeanProperties() {
        return this.set("BeanContext.ignoreUnknownBeanProperties.b", true);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder ignoreUnknownNullBeanProperties(boolean value) {
        return this.set("BeanContext.ignoreUnknownNullBeanProperties.b", value);
    }

    @FluentSetter
    public BeanContextBuilder dontIgnoreUnknownNullBeanProperties() {
        return this.set("BeanContext.ignoreUnknownNullBeanProperties.b", false);
    }

    @FluentSetter
    public BeanContextBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        return this.putTo("BeanContext.implClasses.smc", interfaceClass.getName(), implClass);
    }

    @FluentSetter
    public BeanContextBuilder implClasses(Map<Class<?>, Class<?>> values) {
        for (Map.Entry<Class<?>, Class<?>> e : values.entrySet()) {
            this.putTo("BeanContext.implClasses.smc", e.getKey().getName(), e.getValue());
        }
        return this;
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder includeProperties(Class<?> beanClass, String value) {
        return this.putTo("BeanContext.bpi.sms", beanClass.getName(), value);
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder includeProperties(Map<String, String> values) {
        return this.set("BeanContext.bpi.sms", values);
    }

    @FluentSetter
    @Deprecated
    public BeanContextBuilder includeProperties(String beanClassName, String value) {
        return this.putTo("BeanContext.bpi.sms", beanClassName, value);
    }

    @FluentSetter
    public BeanContextBuilder interfaceClass(Class<?> on, Class<?> value) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(on).interfaceClass(value));
    }

    @FluentSetter
    public BeanContextBuilder interfaces(Class<?> ... value) {
        for (Class<?> v : value) {
            this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(v).interfaceClass(v));
        }
        return this;
    }

    @FluentSetter
    public BeanContextBuilder notBeanClasses(Object ... values) {
        return this.addTo("BeanContext.notBeanClasses.sc", values);
    }

    @FluentSetter
    public BeanContextBuilder notBeanPackages(Object ... values) {
        for (Object o : values) {
            if (o instanceof Package) {
                this.addTo("BeanContext.notBeanPackages.ss", ((Package)o).getName());
                continue;
            }
            if (o instanceof String) {
                this.addTo("BeanContext.notBeanPackages.ss", o.toString());
                continue;
            }
            if (o instanceof Collection) {
                for (Object o2 : (Collection)o) {
                    this.notBeanPackages(o2);
                }
                continue;
            }
            if (!o.getClass().isArray()) continue;
            for (int i = 0; i < Array.getLength(o); ++i) {
                this.notBeanPackages(Array.get(o, i));
            }
        }
        return this;
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder pojoSwaps(Object ... values) {
        return this.appendTo("BeanContext.pojoSwaps.lo", values);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder pojoSwapsReplace(Object ... values) {
        return this.set("BeanContext.pojoSwaps.lo", values);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder pojoSwapsRemove(Object ... values) {
        return this.removeFrom("BeanContext.pojoSwaps.lo", values);
    }

    @FluentSetter
    public BeanContextBuilder propertyNamer(Class<? extends PropertyNamer> value) {
        return this.set("BeanContext.propertyNamer.c", value);
    }

    @FluentSetter
    public BeanContextBuilder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(on).propertyNamer(value));
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder sortProperties(boolean value) {
        return this.set("BeanContext.sortProperties.b", value);
    }

    @FluentSetter
    public BeanContextBuilder sortProperties() {
        return this.set("BeanContext.sortProperties.b", true);
    }

    @FluentSetter
    public BeanContextBuilder sortProperties(Class<?> ... on) {
        for (Class<?> c : on) {
            this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(c).sort(true));
        }
        return this;
    }

    @FluentSetter
    public BeanContextBuilder stopClass(Class<?> on, Class<?> value) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(on).stopClass(value));
    }

    @FluentSetter
    public BeanContextBuilder swaps(Object ... values) {
        return this.appendTo("BeanContext.swaps.lo", values);
    }

    @FluentSetter
    public BeanContextBuilder typeName(Class<?> on, String value) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(on).typeName(value));
    }

    @FluentSetter
    public BeanContextBuilder typePropertyName(String value) {
        return this.set("BeanContext.typePropertyName.s", value);
    }

    @FluentSetter
    public BeanContextBuilder typePropertyName(Class<?> on, String value) {
        return this.prependTo("BeanContext.annotations.lo", new BeanAnnotation(on).typePropertyName(value));
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder useEnumNames(boolean value) {
        return this.set("BeanContext.useEnumNames.b", value);
    }

    @FluentSetter
    public BeanContextBuilder useEnumNames() {
        return this.set("BeanContext.useEnumNames.b", true);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder useInterfaceProxies(boolean value) {
        return this.set("BeanContext.useInterfaceProxies.b", value);
    }

    @FluentSetter
    public BeanContextBuilder dontUseInterfaceProxies() {
        return this.set("BeanContext.useInterfaceProxies.b", false);
    }

    @Deprecated
    @FluentSetter
    public BeanContextBuilder useJavaBeanIntrospector(boolean value) {
        return this.set("BeanContext.useJavaBeanIntrospector.b", value);
    }

    @FluentSetter
    public BeanContextBuilder useJavaBeanIntrospector() {
        return this.set("BeanContext.useJavaBeanIntrospector.b", true);
    }

    @Override
    public BeanContextBuilder add(Map<String, Object> properties) {
        super.add(properties);
        return this;
    }

    @Override
    public BeanContextBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public BeanContextBuilder appendTo(String name, Object value) {
        super.appendTo(name, value);
        return this;
    }

    @Override
    public BeanContextBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public BeanContextBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations(fromClasses);
        return this;
    }

    @Override
    public BeanContextBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }

    @Override
    public BeanContextBuilder applyAnnotations(AnnotationList al, VarResolverSession r) {
        super.applyAnnotations(al, r);
        return this;
    }

    @Override
    public BeanContextBuilder debug() {
        super.debug();
        return this;
    }

    @Override
    public BeanContextBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public BeanContextBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public BeanContextBuilder prependTo(String name, Object value) {
        super.prependTo(name, value);
        return this;
    }

    @Override
    public BeanContextBuilder putAllTo(String name, Object value) {
        super.putAllTo(name, value);
        return this;
    }

    @Override
    public BeanContextBuilder putTo(String name, String key, Object value) {
        super.putTo(name, key, value);
        return this;
    }

    @Override
    public BeanContextBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public BeanContextBuilder set(Map<String, Object> properties) {
        super.set(properties);
        return this;
    }

    @Override
    public BeanContextBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public BeanContextBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }
}

