/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSessionArgs;

@ConfigurableContext
public abstract class Parser
extends BeanContext {
    static final String PREFIX = "Parser";
    public static final String PARSER_autoCloseStreams = "Parser.autoCloseStreams.b";
    public static final String PARSER_debugOutputLines = "Parser.debugOutputLines.i";
    public static final String PARSER_listener = "Parser.listener.c";
    public static final String PARSER_strict = "Parser.strict.b";
    public static final String PARSER_trimStrings = "Parser.trimStrings.b";
    public static final String PARSER_unbuffered = "Parser.unbuffered.b";
    static Parser DEFAULT = new Parser(PropertyStore.create().build(), new String[0]){

        @Override
        public ParserSession createSession(ParserSessionArgs args) {
            throw new NoSuchMethodError();
        }
    };
    private final boolean trimStrings = this.getBooleanProperty("Parser.trimStrings.b", false);
    private final boolean strict = this.getBooleanProperty("Parser.strict.b", false);
    private final boolean autoCloseStreams = this.getBooleanProperty("Parser.autoCloseStreams.b", false);
    private final boolean unbuffered;
    private final int debugOutputLines = this.getIntegerProperty("Parser.debugOutputLines.i", 5);
    private final Class<? extends ParserListener> listener;
    private final MediaType[] consumes;

    protected Parser(PropertyStore ps, String ... consumes) {
        super(ps);
        this.unbuffered = this.getBooleanProperty(PARSER_unbuffered, false);
        this.listener = this.getClassProperty(PARSER_listener, ParserListener.class, null);
        this.consumes = new MediaType[consumes.length];
        for (int i = 0; i < consumes.length; ++i) {
            this.consumes[i] = MediaType.of(consumes[i]);
        }
    }

    @Override
    public ParserBuilder builder() {
        return new ParserBuilder(this.getPropertyStore());
    }

    public static ParserBuilder create() {
        return new ParserBuilder(PropertyStore.DEFAULT);
    }

    public boolean isReaderParser() {
        return true;
    }

    public abstract ParserSession createSession(ParserSessionArgs var1);

    public final <T> T parse(Object input, Type type, Type ... args) throws ParseException, IOException {
        return this.createSession().parse(input, type, args);
    }

    public final <T> T parse(String input, Type type, Type ... args) throws ParseException {
        return this.createSession().parse(input, type, args);
    }

    public final <T> T parse(Object input, Class<T> type) throws ParseException, IOException {
        return this.createSession().parse(input, type);
    }

    public final <T> T parse(String input, Class<T> type) throws ParseException {
        return this.createSession().parse(input, type);
    }

    public final <T> T parse(Object input, ClassMeta<T> type) throws ParseException, IOException {
        return this.createSession().parse(input, type);
    }

    public final <T> T parse(String input, ClassMeta<T> type) throws ParseException {
        return this.createSession().parse(input, type);
    }

    @Override
    public ParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public final ParserSessionArgs createDefaultSessionArgs() {
        return new ParserSessionArgs().mediaType(this.getPrimaryMediaType());
    }

    public final <K, V> Map<K, V> parseIntoMap(Object input, Map<K, V> m, Type keyType, Type valueType) throws ParseException {
        return this.createSession().parseIntoMap(input, m, keyType, valueType);
    }

    public final <E> Collection<E> parseIntoCollection(Object input, Collection<E> c, Type elementType) throws ParseException {
        return this.createSession().parseIntoCollection(input, c, elementType);
    }

    public final Object[] parseArgs(Object input, Type[] argTypes) throws ParseException {
        if (argTypes == null || argTypes.length == 0) {
            return new Object[0];
        }
        return this.createSession().parseArgs(input, argTypes);
    }

    public final MediaType[] getMediaTypes() {
        return this.consumes;
    }

    public final MediaType getPrimaryMediaType() {
        return this.consumes == null || this.consumes.length == 0 ? null : this.consumes[0];
    }

    public boolean canHandle(String contentType) {
        if (contentType != null) {
            for (MediaType mt : this.getMediaTypes()) {
                if (!contentType.equals(mt.toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean isAutoCloseStreams() {
        return this.autoCloseStreams;
    }

    protected final int getDebugOutputLines() {
        return this.debugOutputLines;
    }

    protected final Class<? extends ParserListener> getListener() {
        return this.listener;
    }

    protected final boolean isStrict() {
        return this.strict;
    }

    protected final boolean isTrimStrings() {
        return this.trimStrings;
    }

    protected final boolean isUnbuffered() {
        return this.unbuffered;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("autoCloseStreams", this.autoCloseStreams).a("debugOutputLines", this.debugOutputLines).a("listener", this.listener).a("strict", this.strict).a("trimStrings", this.trimStrings).a("unbuffered", this.unbuffered));
    }

    public static abstract class Null
    extends Parser {
        private Null(PropertyStore ps, String[] consumes) {
            super(ps, consumes);
        }
    }
}

