/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;

import org.apache.myfaces.orchestra.CoreConfig;
import org.apache.myfaces.orchestra.connectionManager.ConnectionManagerDataSource;

/**
 * RequestHandler that ensures that any jdbc connections allocated during
 * the course of this request are freed at the end.
 * 
 * @since 1.1
 */
class DataSourceLeakRequestHandler implements RequestHandler
{
    boolean enabled;

    public void init(FacesContext facesContext) throws FacesException
    {
        // Check for the normal global init param; true unless "false" is specified 
        String value = facesContext.getExternalContext().getInitParameter(CoreConfig.SERIALIZE_REQUESTS);
        enabled = !"false".equals(value);
    }

    public void deinit() throws FacesException
    {
        if (enabled)
        {
            ConnectionManagerDataSource.releaseAllBorrowedConnections();
        }
    }
}

