// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIHidden;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.HiddenTagDeclaration}.
 */
public final class HiddenTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(HiddenTag.class);
  private javax.el.ValueExpression  readonly;
  private javax.el.ValueExpression  converter;
  private javax.el.MethodExpression  validator;
  private javax.el.ValueExpression  disabled;
  private javax.el.ValueExpression  value;

  @Override
  public String getComponentType() {
    return UIHidden.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Hidden";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIHidden component = (UIHidden) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (readonly != null) {
      if (!readonly.isLiteralText()) {
        component.setValueExpression("readonly", readonly);
      } else {
        component.setReadonly(Boolean.parseBoolean(readonly.getExpressionString()));
      }
    }
    if (converter != null) {
      if (!converter.isLiteralText()) {
        component.setValueExpression("converter", converter);
      } else {
        component.setConverter(application.createConverter(converter.getExpressionString()));
      }
    }
    if (validator != null) {
      component.addValidator(new javax.faces.validator.MethodExpressionValidator(validator));
    }
    if (disabled != null) {
      if (!disabled.isLiteralText()) {
        component.setValueExpression("disabled", disabled);
      } else {
        component.setDisabled(Boolean.parseBoolean(disabled.getExpressionString()));
      }
    }
    if (value != null) {
      component.setValueExpression("value", value);
    }

  }

  public javax.el.ValueExpression getReadonly() {
    return readonly;
  }

  public void setReadonly(final javax.el.ValueExpression readonly) {
    this.readonly = readonly;
  }

  public javax.el.ValueExpression getConverter() {
    return converter;
  }

  public void setConverter(final javax.el.ValueExpression converter) {
    this.converter = converter;
  }

  public javax.el.MethodExpression getValidator() {
    return validator;
  }

  public void setValidator(final javax.el.MethodExpression validator) {
    this.validator = validator;
  }

  public javax.el.ValueExpression getDisabled() {
    return disabled;
  }

  public void setDisabled(final javax.el.ValueExpression disabled) {
    this.disabled = disabled;
  }

  public javax.el.ValueExpression getValue() {
    return value;
  }

  public void setValue(final javax.el.ValueExpression value) {
    this.value = value;
  }



  @Override
  public void release() {
    super.release();
    readonly = null;
    converter = null;
    validator = null;
    disabled = null;
    value = null;
  }
}