// ---------- Attention: Generated code, please do not modify! -----------

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.renderkit.css.CustomClass;
import org.apache.myfaces.tobago.sanitizer.SanitizeMode;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.component.Tags;
import javax.annotation.Generated;
import javax.el.ELException;
import javax.faces.FacesException;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

/**
 Renders a text
  * UIComponent class, generated from template {@code component.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.OutTagDeclaration}.
 */
@Generated("component.stg")
public class UIOut
    extends AbstractUIOut implements ClientBehaviorHolder {

  private static final Tags TAG = Tags.out;

  public static final String COMPONENT_TYPE = TAG.componentType();

  public static final String COMPONENT_FAMILY = "javax.faces.Output";


  enum PropertyKeys {
    markup,
    compact,
    messageFormat,
    labelLayout,
    messagePosition,
    label,
    autoSpacing,
    helpPosition,
    plain,
    customClass,
    keepLineBreaks,
    tip,
    createSpan,
    escape,
    sanitize,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  public org.apache.myfaces.tobago.context.Markup getMarkup() {
    Object object = getStateHelper().eval(PropertyKeys.markup);
    if (object != null) {
      return Markup.valueOf(object);
    }
    return null;
  }

  public void setMarkup(org.apache.myfaces.tobago.context.Markup markup) {
    getStateHelper().put(PropertyKeys.markup, markup);
  }

  /**
  This attribute is useful if labelLayout=skip is set.
   Use true, if you want to only render the text (no surrounding tag).
   Use false, if you enable the possibility to apply styles to the output.
  <br>Default: <code>false</code>
  @deprecated*/
  @Deprecated
  public boolean isCompact() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.compact);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  @Deprecated
  public void setCompact(boolean compact) {
      Deprecation.LOG.error("The attribute 'compact' of 'UIOut' is deprecated. "
          + "Please refer the documentation for further information.");
    getStateHelper().put(PropertyKeys.compact, compact);
  }

  /**
  Activates formatting of the value with the method {
  <br>Default: <code>false</code>
  */
  public boolean isMessageFormat() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.messageFormat);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setMessageFormat(boolean messageFormat) {
    getStateHelper().put(PropertyKeys.messageFormat, messageFormat);
  }

  /**
  Defines the position of the label relative to the field.
   The default is flexLeft, if the label is set, or none, if the label isn't set.
   Set to 'skip' to avoid surrounding label container.
   Hint for tc:out: set also compact=true to render only text (without html tags).

  */
  public org.apache.myfaces.tobago.component.LabelLayout getLabelLayout() {
    org.apache.myfaces.tobago.component.LabelLayout labelLayout = (org.apache.myfaces.tobago.component.LabelLayout) getStateHelper().eval(PropertyKeys.labelLayout);
    if (labelLayout != null) {
      return labelLayout;
    }
    return getLabel() == null
          ? LabelLayout.none
          : LabelLayout.valueOf(org.apache.myfaces.tobago.context.TobagoContext.getInstance(getFacesContext()).getTheme().getTagAttributeDefault(TAG, "labelLayout"));
  }

  public void setLabelLayout(org.apache.myfaces.tobago.component.LabelLayout labelLayout) {
    getStateHelper().put(PropertyKeys.labelLayout, labelLayout);
  }

  /**
  Defines the position and the appearance of additional faces messages (like error message or help message) on a
   component.
   The default is popoverRight.

  */
  public org.apache.myfaces.tobago.component.DecorationPosition getMessagePosition() {
    org.apache.myfaces.tobago.component.DecorationPosition messagePosition = (org.apache.myfaces.tobago.component.DecorationPosition) getStateHelper().eval(PropertyKeys.messagePosition);
    if (messagePosition != null) {
      return messagePosition;
    }
    return DecorationPosition.valueOf(org.apache.myfaces.tobago.context.TobagoContext.getInstance(getFacesContext()).getTheme().getTagAttributeDefault(TAG, "messagePosition"));
  }

  public void setMessagePosition(org.apache.myfaces.tobago.component.DecorationPosition messagePosition) {
    getStateHelper().put(PropertyKeys.messagePosition, messagePosition);
  }

  /**
  A localized user presentable label for this component.

  */
  public java.lang.String getLabel() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.label);
  }

  public void setLabel(java.lang.String label) {
    getStateHelper().put(PropertyKeys.label, label);
  }

  /**
  Automatically add spacing (margins/paddings) to the component for better positioning.
   Default is 'true' except the component is inside a:
   - header
   - footer
   - bar
   - sheet
   - tree
   - link group
   - button group
   - before facet
   - after facet
   - label facet
   - bar facet

  */
  public Boolean getAutoSpacing() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.autoSpacing);
    if (bool != null) {
      return bool;
    }
    return null;
  }

  public void setAutoSpacing(Boolean autoSpacing) {
    getStateHelper().put(PropertyKeys.autoSpacing, autoSpacing);
  }

  /**
  Defines the position and the appearance of a help message on a component.
   The default is popoverRight.

  */
  public org.apache.myfaces.tobago.component.DecorationPosition getHelpPosition() {
    org.apache.myfaces.tobago.component.DecorationPosition helpPosition = (org.apache.myfaces.tobago.component.DecorationPosition) getStateHelper().eval(PropertyKeys.helpPosition);
    if (helpPosition != null) {
      return helpPosition;
    }
    return DecorationPosition.valueOf(org.apache.myfaces.tobago.context.TobagoContext.getInstance(getFacesContext()).getTheme().getTagAttributeDefault(TAG, "helpPosition"));
  }

  public void setHelpPosition(org.apache.myfaces.tobago.component.DecorationPosition helpPosition) {
    getStateHelper().put(PropertyKeys.helpPosition, helpPosition);
  }

  /**
  <p><b>Use with caution: Only for special cases!</b></p>

   <p>This attribute is useful for tc:out if labelLayout=skip is set.
   Use true, if you want to only render the text (no surrounding tag).
   Use false, if you enable the possibility to apply styles to the output.</p>

   <p>For tc:form there will no div tag be rendered. So, the content
   can be used freely from layout managers.</p>

   <p>But, no AJAX is possible for components with "plain" set,
   because there is no client element with an "id" in the DOM.</p>
  <br>Default: <code>false</code>
  */
  public boolean isPlain() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.plain);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setPlain(boolean plain) {
    getStateHelper().put(PropertyKeys.plain, plain);
  }

  /**
  Sets a CSS class in its parent, if the parent supports it.

   Which this feature it is possible to put a CSS class name into a component with the &lt;tc:style&gt; tag. Example:

   <pre>
   &lt;tc:in&gt;
     &lt;tc:style customClass="my-emphasized"/&gt;
   &lt;/tc:in&gt;
   </pre>

   One capability is, to used external CSS libs.
   <br>
   This feature should not be used imprudent.
   Because it might be unstable against changes in the renderered HTML code.

  */
  public org.apache.myfaces.tobago.renderkit.css.CustomClass getCustomClass() {
    return (org.apache.myfaces.tobago.renderkit.css.CustomClass) getStateHelper().eval(PropertyKeys.customClass);
  }

  public void setCustomClass(org.apache.myfaces.tobago.renderkit.css.CustomClass customClass) {
    getStateHelper().put(PropertyKeys.customClass, customClass);
  }

  /**
  Flag indicating that new-line characters will be converted to HTML &lt;br&gt;.
   This is useful for pre-formatted plain text.
   This has only an effect, with escape="true".
  <br>Default: <code>true</code>
  */
  public boolean isKeepLineBreaks() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.keepLineBreaks);
    if (bool != null) {
      return bool;
    }
    return true;
  }

  public void setKeepLineBreaks(boolean keepLineBreaks) {
    getStateHelper().put(PropertyKeys.keepLineBreaks, keepLineBreaks);
  }

  /**
  Text value to display as tooltip.

  */
  public java.lang.String getTip() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.tip);
  }

  public void setTip(java.lang.String tip) {
    getStateHelper().put(PropertyKeys.tip, tip);
  }

  /**
  Indicates that the renderer should create an element in the output language
   (e. g. an span or div tag around the output text).
   Use true, if you enable the possibility to apply styles to the output.
   Use false, if you want to keep the code small (especially inside of sheets).
  <br>Default: <code>true</code>
  @deprecated*/
  @Deprecated
  public boolean isCreateSpan() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.createSpan);
    if (bool != null) {
      return bool;
    }
    return true;
  }

  @Deprecated
  public void setCreateSpan(boolean createSpan) {
      Deprecation.LOG.error("The attribute 'createSpan' of 'UIOut' is deprecated. "
          + "Please refer the documentation for further information.");
    getStateHelper().put(PropertyKeys.createSpan, createSpan);
  }

  /**
  Flag indicating that characters that are sensitive in HTML and XML markup must be escaped.
  <br>Default: <code>true</code>
  */
  public boolean isEscape() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.escape);
    if (bool != null) {
      return bool;
    }
    return true;
  }

  public void setEscape(boolean escape) {
    getStateHelper().put(PropertyKeys.escape, escape);
  }

  /**
  Should HTML content sanitized?
   The effect of sanitizing depends on the configuration.
   The value "auto" means, that sanitizing take place for
   <ul>
     <li>tc:out when escape="false" or</li>
     <li>tc:popover when escape="false" or</li>
     <li>tc:textarea when attribute data-html-editor is set,</li>
   </ul>
   because that are the critical parts.
  <br>Default: <code>auto</code><br>Allowed Values: <code>auto,never</code>
  */
  public org.apache.myfaces.tobago.sanitizer.SanitizeMode getSanitize() {
    org.apache.myfaces.tobago.sanitizer.SanitizeMode sanitize = (org.apache.myfaces.tobago.sanitizer.SanitizeMode) getStateHelper().eval(PropertyKeys.sanitize);
    if (sanitize != null) {
      return sanitize;
    }
    return org.apache.myfaces.tobago.sanitizer.SanitizeMode.auto;
  }

  public void setSanitize(org.apache.myfaces.tobago.sanitizer.SanitizeMode sanitize) {
    getStateHelper().put(PropertyKeys.sanitize, sanitize);
  }


  @Override
  public void restoreState(FacesContext context, Object state) {
    // FIXME HACK for mojarra SystemEventListener state restoring bug
    pushComponentToEL(context, this);
    super.restoreState(context, state);
    popComponentFromEL(context);
  }

}