/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.renderkit.Collapse;
import org.apache.myfaces.tobago.internal.renderkit.Command;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private JsonUtils() {
    }

    private static void encode(StringBuilder builder, String name, String[] value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        JsonUtils.encode(builder, value);
        builder.append(",");
    }

    private static void encode(StringBuilder builder, String[] value) {
        builder.append("[");
        boolean colon = false;
        for (String item : value) {
            if (colon) {
                builder.append(",");
            }
            builder.append("\"");
            for (int i = 0; i < item.length(); ++i) {
                char c = item.charAt(i);
                if (c == '\"') {
                    builder.append("\\\"");
                    continue;
                }
                builder.append(c);
            }
            builder.append("\"");
            colon = true;
        }
        builder.append("]");
    }

    private static void encode(StringBuilder builder, Boolean[] value) {
        builder.append("[");
        boolean colon = false;
        Boolean[] booleanArray = value;
        int n = booleanArray.length;
        for (int i = 0; i < n; ++i) {
            boolean item = booleanArray[i];
            if (colon) {
                builder.append(",");
            }
            builder.append(item);
            colon = true;
        }
        builder.append("]");
    }

    private static void encode(StringBuilder builder, List<Integer> value) {
        builder.append("[");
        boolean colon = false;
        for (Integer item : value) {
            if (colon) {
                builder.append(",");
            }
            builder.append(item);
            colon = true;
        }
        builder.append("]");
    }

    private static void encode(StringBuilder builder, String name, Boolean value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        builder.append(value);
        builder.append(",");
    }

    private static void encode(StringBuilder builder, String name, Integer value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":");
        builder.append(value);
        builder.append(",");
    }

    private static void encode(StringBuilder builder, String name, String value) {
        builder.append("\"");
        builder.append(name);
        builder.append("\":\"");
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            builder.append(c);
        }
        builder.append("\",");
    }

    public static String encode(CommandMap commandMap) {
        Map<ClientBehaviors, Command> other;
        if (commandMap == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int initialLength = builder.length();
        Command click = commandMap.getClick();
        if (click != null) {
            JsonUtils.encode(builder, ClientBehaviors.click, click);
        }
        if ((other = commandMap.getOther()) != null) {
            for (Map.Entry<ClientBehaviors, Command> entry : other.entrySet()) {
                JsonUtils.encode(builder, entry.getKey(), entry.getValue());
            }
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
        return builder.toString();
    }

    private static void encode(StringBuilder builder, ClientBehaviors name, Command command) {
        Boolean omit;
        Integer delay;
        String confirmation;
        Collapse collapse;
        String render;
        String execute;
        String target;
        Boolean transition;
        String fieldId;
        builder.append("\"");
        builder.append((Object)name);
        builder.append("\":{");
        int initialLength = builder.length();
        String clientId = command.getClientId();
        if (clientId != null) {
            JsonUtils.encode(builder, "clientId", clientId);
        }
        if ((fieldId = command.getFieldId()) != null) {
            JsonUtils.encode(builder, "fieldId", fieldId);
        }
        if ((transition = command.getTransition()) != null && !transition.booleanValue()) {
            JsonUtils.encode(builder, "transition", transition);
        }
        if ((target = command.getTarget()) != null) {
            JsonUtils.encode(builder, "target", target);
        }
        if ((execute = command.getExecute()) != null) {
            JsonUtils.encode(builder, "execute", execute);
        }
        if ((render = command.getRender()) != null) {
            JsonUtils.encode(builder, "render", render);
        }
        if ((collapse = command.getCollapse()) != null) {
            JsonUtils.encode(builder, "collapse", collapse);
        }
        if ((confirmation = command.getConfirmation()) != null) {
            JsonUtils.encode(builder, "confirmation", confirmation);
        }
        if ((delay = command.getDelay()) != null) {
            JsonUtils.encode(builder, "delay", delay);
        }
        if ((omit = command.getOmit()) != null && omit.booleanValue()) {
            JsonUtils.encode(builder, "omit", true);
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("},");
    }

    private static void encode(StringBuilder builder, String name, Collapse collapse) {
        String forId;
        builder.append("\"");
        builder.append(name);
        builder.append("\":{");
        int initialLength = builder.length();
        Collapse.Operation action = collapse.getOperation();
        if (action != null) {
            JsonUtils.encode(builder, "transition", action.name());
        }
        if ((forId = collapse.getFor()) != null) {
            JsonUtils.encode(builder, "forId", forId);
        }
        if (builder.length() - initialLength > 0) {
            assert (builder.charAt(builder.length() - 1) == ',');
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("},");
    }

    public static String encode(String[] strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JsonUtils.encode(builder, strings);
        return builder.toString();
    }

    public static String encode(Integer[] integers) {
        if (integers == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JsonUtils.encode(builder, Arrays.asList(integers));
        return builder.toString();
    }

    public static String encode(Boolean[] booleans) {
        if (booleans == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JsonUtils.encode(builder, booleans);
        return builder.toString();
    }

    public static String encode(List<Integer> integers) {
        if (integers == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        JsonUtils.encode(builder, integers);
        return builder.toString();
    }

    private static void encode(MeasureList layout, StringBuilder builder) {
        builder.append("[");
        for (Measure measure : layout) {
            Measure.Unit unit = measure.getUnit();
            if (unit == Measure.Unit.FR) {
                float factor = measure.getValue();
                builder.append(factor);
            } else if (unit == Measure.Unit.AUTO) {
                builder.append("\"auto\"");
            } else {
                builder.append("{\"measure\":\"");
                builder.append(measure.serialize());
                builder.append("\"}");
            }
            builder.append(',');
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("]");
    }

    public static List<Integer> decodeIntegerArray(String json) {
        if (json == null) {
            return null;
        }
        String string = json.trim();
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (string.length() < 2 || string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') {
            LOG.warn("Can't parse JSON array: no surrounding square brackets []: '{}'", (Object)string);
        } else {
            string = string.substring(1, string.length() - 1);
            StringTokenizer tokenizer = new StringTokenizer(string, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                try {
                    result.add(Integer.parseInt(token));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Can't parse JSON array: not an integer token: '{}'", (Object)token);
                }
            }
        }
        return result;
    }

    public static String encode(Markup markups) {
        if (markups == null || markups.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder(20);
        builder.append('[');
        for (String markup : markups) {
            builder.append('\"');
            builder.append(markup);
            builder.append('\"');
            builder.append(',');
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(']');
        return builder.toString();
    }

    public static String encode(MeasureList measures, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"");
        builder.append(name);
        builder.append("\":");
        JsonUtils.encode(measures, builder);
        builder.append("}");
        return builder.toString();
    }

    public static String encodeEmptyArray() {
        return "[]";
    }
}

