/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.core.CoreStyleSheet;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;

public class StyleSheetRenderer
extends XhtmlRenderer {
    public static final String DISABLE_CONTENT_COMPRESSION = "org.apache.myfaces.trinidad.DISABLE_CONTENT_COMPRESSION";
    private static final String _SUPPRESS_STYLESHEET_ID_PARAM = "org.apache.myfaces.trinidad.skin.suppressStylesheet";

    public StyleSheetRenderer() {
        this(CoreStyleSheet.TYPE);
    }

    protected StyleSheetRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StyleContext sContext = ((CoreRenderingContext)arc).getStyleContext();
        StyleProvider provider = sContext.getStyleProvider();
        if (provider != null) {
            List<String> uris = provider.getStyleSheetURIs(sContext);
            boolean suppressStylesheet = this._isSuppressStylesheet(context, arc);
            if (!suppressStylesheet) {
                if (uris != null && !uris.isEmpty()) {
                    ExternalContext externalContext = context.getExternalContext();
                    String contextUri = externalContext.getRequestContextPath();
                    String baseURL = contextUri + "/adf/styles/cache/";
                    String outputMode = arc.getOutputMode();
                    if ("portlet".equals(outputMode) && StyleSheetRenderer.supportsScripting(arc)) {
                        writer.startElement("script", null);
                        writer.writeText((Object)"var _adfSS;if(!_adfSS){_adfSS=1;", null);
                        for (String uri : uris) {
                            writer.writeText((Object)"document.write(\"<link rel=\\\"stylesheet\\\" charset=\\\"UTF-8\\\" type=\\\"text/css\\\" href=\\\"", null);
                            uri = context.getExternalContext().encodeResourceURL(baseURL + uri);
                            writer.writeText((Object)uri, null);
                            writer.writeText((Object)"\\\">\");", null);
                        }
                        writer.writeText((Object)"}", null);
                        writer.endElement("script");
                    } else {
                        for (String uri : uris) {
                            writer.startElement("link", null);
                            this.renderId(context, comp);
                            writer.writeAttribute("rel", (Object)"stylesheet", null);
                            writer.writeAttribute("charset", (Object)"UTF-8", null);
                            String type = provider.getContentStyleType(sContext);
                            writer.writeAttribute("type", (Object)type, null);
                            this.renderEncodedResourceURI(context, "href", baseURL + uri);
                            writer.endElement("link");
                        }
                    }
                } else if (arc.getSkin() == null) {
                    writer.writeComment((Object)"ERROR: Could not create stylesheet, because no skin is available");
                } else {
                    writer.writeComment((Object)("ERROR: could not create stylesheet for " + arc.getSkin().getStyleSheetName()));
                }
            }
            if (arc instanceof CoreRenderingContext) {
                Map shortStyles = arc.getSkin().getStyleClassMap(arc);
                ((CoreRenderingContext)arc).setStyleMap(shortStyles);
            }
        }
    }

    private boolean _isSuppressStylesheet(FacesContext context, RenderingContext arc) {
        Map requestMap;
        boolean suppressStylesheet;
        if (!StyleSheetRenderer._supportsExternalStylesheet(arc)) {
            return true;
        }
        String outputMode = arc.getOutputMode();
        if ("portlet".equals(outputMode) && (suppressStylesheet = "true".equals((requestMap = context.getExternalContext().getRequestMap()).get(_SUPPRESS_STYLESHEET_ID_PARAM)))) {
            return ((CoreRenderingContext)arc).isRequestMapStyleSheetIdAndSkinEqual(context, arc.getSkin());
        }
        return false;
    }

    private static boolean _supportsExternalStylesheet(RenderingContext arc) {
        Object styleCapability = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_STYLE_ATTRIBUTES);
        return styleCapability == null || TrinidadAgent.STYLES_EXTERNAL == styleCapability;
    }
}

