/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.icon;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.style.Style;
import org.apache.myfaces.trinidadinternal.style.util.StyleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextIcon
extends Icon {
    private String _text;
    private String _rtlText;
    private String _styleClass;
    private Style _inlineStyle;

    public TextIcon(String text) {
        this(text, null, null, null);
    }

    public TextIcon(String text, String rtlText) {
        this(text, rtlText, null, null);
    }

    public TextIcon(String text, String rtlText, String styleClass, Style inlineStyle) {
        this._text = text;
        this._rtlText = rtlText;
        this._styleClass = styleClass;
        this._inlineStyle = inlineStyle;
    }

    public void renderIcon(FacesContext context, RenderingContext arc, Map<String, ? extends Object> attrs) throws IOException {
        boolean hasTitle;
        Object id = null;
        String styleClass = this._styleClass;
        Object title = null;
        Object attrInlineStyle = null;
        Object attrStyles = null;
        boolean embedded = false;
        if (attrs != null) {
            attrInlineStyle = this._getInlineStyle(attrs);
            attrStyles = this._getStyles(attrs);
            id = attrs.get("id");
            title = this._getTitle(attrs);
            embedded = this._isEmbedded(attrs);
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean useSpan = TextIcon._useSpan(styleClass, this._inlineStyle, title, embedded);
        if (useSpan) {
            writer.startElement("span", null);
        }
        if (id != null) {
            writer.writeAttribute("id", id, null);
        }
        boolean screenReader = arc.getAccessibilityMode() == RequestContext.Accessibility.SCREEN_READER;
        boolean bl = hasTitle = title != null && !"".equals(title);
        if (hasTitle && !screenReader) {
            writer.writeAttribute("title", title, null);
        }
        StringBuilder styleClasses = new StringBuilder();
        if (styleClass != null) {
            String convertedStyleClass = StyleUtils.convertToValidSelector(arc.getStyleClass(this._styleClass));
            styleClasses.append(convertedStyleClass);
        }
        if (attrStyles != null) {
            if (styleClasses.length() > 0) {
                styleClasses.append(" ");
            }
            styleClasses.append(arc.getStyleClass(attrStyles.toString()));
        }
        if (styleClasses.length() > 0) {
            writer.writeAttribute("class", (Object)styleClasses.toString(), null);
        }
        StringBuilder inline = new StringBuilder(100);
        if (this._inlineStyle != null) {
            inline.append(this._inlineStyle.toInlineString());
        }
        if (attrInlineStyle != null && !"".equals(attrInlineStyle)) {
            inline.append(attrInlineStyle.toString());
        }
        if (inline.length() > 0) {
            writer.writeAttribute("style", (Object)inline.toString(), null);
        }
        String text = this.getText(arc);
        writer.writeText((Object)text, null);
        if (hasTitle && screenReader) {
            writer.writeText((Object)" ", null);
            writer.writeText(title, null);
        }
        if (useSpan) {
            writer.endElement("span");
        }
    }

    protected Style getInlineStyle() {
        return this._inlineStyle;
    }

    protected String getRtlText() {
        return this._rtlText;
    }

    protected String getStyleClass() {
        return this._styleClass;
    }

    protected String getText(RenderingContext arc) {
        if (this._rtlText != null && arc.isRightToLeft()) {
            return this._rtlText;
        }
        return this._text;
    }

    public void setInlineStyle(Style inlineStyle) {
        this._inlineStyle = inlineStyle;
    }

    public void setRtlText(String rtlText) {
        this._rtlText = rtlText;
    }

    public void setStyleClass(String styleClass) {
        this._styleClass = styleClass;
    }

    public void setText(String text) {
        this._text = text;
    }

    private Object _getInlineStyle(Map<String, ? extends Object> attrs) {
        assert (attrs != null);
        return attrs.get("inlineStyle");
    }

    private Object _getStyles(Map<String, ? extends Object> attrs) {
        assert (attrs != null);
        return attrs.get("styleClass");
    }

    private Object _getTitle(Map<String, ? extends Object> attrs) {
        assert (attrs != null);
        return attrs.get("shortDesc");
    }

    private boolean _isEmbedded(Map<String, ? extends Object> attrs) {
        assert (attrs != null);
        return Boolean.TRUE.equals(attrs.get("embedded"));
    }

    private static boolean _useSpan(Object styleClass, Object inlineStyle, Object title, boolean embedded) {
        return !embedded && (styleClass != null || title != null && !"".equals(title) || inlineStyle != null || title != null);
    }
}

