/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Iterator;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.validator.Validator;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.CoreFormData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ValueRenderer;

public abstract class EditableValueRenderer
extends ValueRenderer {
    private PropertyKey _submittedValueKey;
    private PropertyKey _readOnlyKey;
    private PropertyKey _disabledKey;
    private PropertyKey _requiredKey;
    private PropertyKey _immediateKey;
    private PropertyKey _validatorsKey;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(EditableValueRenderer.class);

    protected EditableValueRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._submittedValueKey = type.findKey("submittedValue");
        this._readOnlyKey = type.findKey("readOnly");
        this._disabledKey = type.findKey("disabled");
        this._requiredKey = type.findKey("required");
        this._immediateKey = type.findKey("immediate");
        this._validatorsKey = type.findKey("validators");
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        Object submittedValue;
        if (this.skipDecode(facesContext)) {
            return;
        }
        if (!this.wasSubmitted(facesContext, component)) {
            submittedValue = null;
        } else {
            if (clientId == null) {
                clientId = component.getClientId(facesContext);
            }
            submittedValue = this.getSubmittedValue(facesContext, component, clientId);
        }
        if (_LOG.isFinest()) {
            if (clientId == null) {
                clientId = component.getClientId(facesContext);
            }
            _LOG.finest("Value submitted for ID {0} is {1}", new Object[]{clientId, submittedValue});
        }
        EditableValueHolder evh = (EditableValueHolder)component;
        evh.setSubmittedValue(submittedValue);
    }

    protected Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        return context.getExternalContext().getRequestParameterMap().get(clientId);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        FacesBean bean = this.getFacesBean(component);
        Converter converter = this.getConverter(component, bean);
        if (converter == null) {
            converter = this.getDefaultConverter(context, component, bean);
        }
        if (converter != null) {
            return converter.getAsObject(context, component, submittedValue != null ? submittedValue.toString() : null);
        }
        return submittedValue;
    }

    protected boolean wasSubmitted(FacesContext context, UIComponent component) {
        FacesBean bean = this.getFacesBean(component);
        return !this.getDisabled(component, bean) && !this.getReadOnly(context, component, bean);
    }

    @Override
    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    @Override
    protected String getConvertedString(FacesContext context, UIComponent component, FacesBean bean) {
        Object o = this.getSubmittedValue(component, bean);
        if (o != null) {
            return o.toString();
        }
        return super.getConvertedString(context, component, bean);
    }

    protected Object getSubmittedValue(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._submittedValueKey);
    }

    protected void addOnSubmitConverterValidators(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        boolean disabled = this.getDisabled(component, bean);
        if (!disabled) {
            boolean requiredField = this.getRequired(component, bean);
            Converter converter = this.getConverter(component, bean);
            if (converter == null) {
                converter = this.getDefaultConverter(context, component, bean);
            }
            Iterator<Validator> validators = this.getValidators(component, bean);
            if (requiredField || converter != null || validators.hasNext()) {
                FormData fData = rc.getFormData();
                if (fData == null) {
                    _LOG.warning("COMPONENT_REQUIRES_FORM", (Object)component);
                    return;
                }
                boolean immediate = this.isImmediate(component, bean);
                ((CoreFormData)fData).addOnSubmitConverterValidators(component, converter, validators, this.getClientId(context, component), immediate, requiredField, this.getRequiredMessageKey());
            }
        }
    }

    protected String getRequiredMessageKey() {
        return "org.apache.myfaces.trinidad.UIXEditableValue.REQUIRED";
    }

    protected boolean getReadOnly(FacesContext context, UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._readOnlyKey);
        if (o == null) {
            o = this._readOnlyKey.getDefault();
        }
        if (Boolean.TRUE.equals(o)) {
            return true;
        }
        ValueExpression ve = this.getValueExpression(component, bean);
        if (ve != null && ve.isReadOnly(context.getELContext())) {
            if (_LOG.isFiner()) {
                _LOG.finer("Value expression {0} is read-only", (Object)ve.getExpressionString());
            }
            return true;
        }
        return false;
    }

    protected boolean getDisabled(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._disabledKey);
        if (o == null) {
            o = this._disabledKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getRequired(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._requiredKey);
        if (o == null) {
            o = this._requiredKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean isImmediate(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._immediateKey);
        if (o == null) {
            o = this._immediateKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected Iterator<Validator> getValidators(UIComponent component, FacesBean bean) {
        return bean.entries(this._validatorsKey);
    }
}

