/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAuthorizationExemptions is the corresponding interface of BACnetConstructedDataAuthorizationExemptions
type BACnetConstructedDataAuthorizationExemptions interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAuthorizationExemption returns AuthorizationExemption (property field)
	GetAuthorizationExemption() []BACnetAuthorizationExemptionTagged
	// IsBACnetConstructedDataAuthorizationExemptions is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAuthorizationExemptions()
	// CreateBuilder creates a BACnetConstructedDataAuthorizationExemptionsBuilder
	CreateBACnetConstructedDataAuthorizationExemptionsBuilder() BACnetConstructedDataAuthorizationExemptionsBuilder
}

// _BACnetConstructedDataAuthorizationExemptions is the data-structure of this message
type _BACnetConstructedDataAuthorizationExemptions struct {
	BACnetConstructedDataContract
	AuthorizationExemption []BACnetAuthorizationExemptionTagged
}

var _ BACnetConstructedDataAuthorizationExemptions = (*_BACnetConstructedDataAuthorizationExemptions)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAuthorizationExemptions)(nil)

// NewBACnetConstructedDataAuthorizationExemptions factory function for _BACnetConstructedDataAuthorizationExemptions
func NewBACnetConstructedDataAuthorizationExemptions(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, authorizationExemption []BACnetAuthorizationExemptionTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAuthorizationExemptions {
	_result := &_BACnetConstructedDataAuthorizationExemptions{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AuthorizationExemption:        authorizationExemption,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAuthorizationExemptionsBuilder is a builder for BACnetConstructedDataAuthorizationExemptions
type BACnetConstructedDataAuthorizationExemptionsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(authorizationExemption []BACnetAuthorizationExemptionTagged) BACnetConstructedDataAuthorizationExemptionsBuilder
	// WithAuthorizationExemption adds AuthorizationExemption (property field)
	WithAuthorizationExemption(...BACnetAuthorizationExemptionTagged) BACnetConstructedDataAuthorizationExemptionsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAuthorizationExemptions or returns an error if something is wrong
	Build() (BACnetConstructedDataAuthorizationExemptions, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAuthorizationExemptions
}

// NewBACnetConstructedDataAuthorizationExemptionsBuilder() creates a BACnetConstructedDataAuthorizationExemptionsBuilder
func NewBACnetConstructedDataAuthorizationExemptionsBuilder() BACnetConstructedDataAuthorizationExemptionsBuilder {
	return &_BACnetConstructedDataAuthorizationExemptionsBuilder{_BACnetConstructedDataAuthorizationExemptions: new(_BACnetConstructedDataAuthorizationExemptions)}
}

type _BACnetConstructedDataAuthorizationExemptionsBuilder struct {
	*_BACnetConstructedDataAuthorizationExemptions

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAuthorizationExemptionsBuilder) = (*_BACnetConstructedDataAuthorizationExemptionsBuilder)(nil)

func (b *_BACnetConstructedDataAuthorizationExemptionsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAuthorizationExemptions
}

func (b *_BACnetConstructedDataAuthorizationExemptionsBuilder) WithMandatoryFields(authorizationExemption []BACnetAuthorizationExemptionTagged) BACnetConstructedDataAuthorizationExemptionsBuilder {
	return b.WithAuthorizationExemption(authorizationExemption...)
}

func (b *_BACnetConstructedDataAuthorizationExemptionsBuilder) WithAuthorizationExemption(authorizationExemption ...BACnetAuthorizationExemptionTagged) BACnetConstructedDataAuthorizationExemptionsBuilder {
	b.AuthorizationExemption = authorizationExemption
	return b
}

func (b *_BACnetConstructedDataAuthorizationExemptionsBuilder) Build() (BACnetConstructedDataAuthorizationExemptions, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAuthorizationExemptions.deepCopy(), nil
}

func (b *_BACnetConstructedDataAuthorizationExemptionsBuilder) MustBuild() BACnetConstructedDataAuthorizationExemptions {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAuthorizationExemptionsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAuthorizationExemptionsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAuthorizationExemptionsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAuthorizationExemptionsBuilder().(*_BACnetConstructedDataAuthorizationExemptionsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAuthorizationExemptionsBuilder creates a BACnetConstructedDataAuthorizationExemptionsBuilder
func (b *_BACnetConstructedDataAuthorizationExemptions) CreateBACnetConstructedDataAuthorizationExemptionsBuilder() BACnetConstructedDataAuthorizationExemptionsBuilder {
	if b == nil {
		return NewBACnetConstructedDataAuthorizationExemptionsBuilder()
	}
	return &_BACnetConstructedDataAuthorizationExemptionsBuilder{_BACnetConstructedDataAuthorizationExemptions: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAuthorizationExemptions) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAuthorizationExemptions) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_AUTHORIZATION_EXEMPTIONS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAuthorizationExemptions) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAuthorizationExemptions) GetAuthorizationExemption() []BACnetAuthorizationExemptionTagged {
	return m.AuthorizationExemption
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAuthorizationExemptions(structType any) BACnetConstructedDataAuthorizationExemptions {
	if casted, ok := structType.(BACnetConstructedDataAuthorizationExemptions); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAuthorizationExemptions); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAuthorizationExemptions) GetTypeName() string {
	return "BACnetConstructedDataAuthorizationExemptions"
}

func (m *_BACnetConstructedDataAuthorizationExemptions) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.AuthorizationExemption) > 0 {
		for _, element := range m.AuthorizationExemption {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataAuthorizationExemptions) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAuthorizationExemptions) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAuthorizationExemptions BACnetConstructedDataAuthorizationExemptions, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAuthorizationExemptions"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAuthorizationExemptions")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	authorizationExemption, err := ReadTerminatedArrayField[BACnetAuthorizationExemptionTagged](ctx, "authorizationExemption", ReadComplex[BACnetAuthorizationExemptionTagged](BACnetAuthorizationExemptionTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'authorizationExemption' field"))
	}
	m.AuthorizationExemption = authorizationExemption

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAuthorizationExemptions"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAuthorizationExemptions")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAuthorizationExemptions) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAuthorizationExemptions) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAuthorizationExemptions"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAuthorizationExemptions")
		}

		if err := WriteComplexTypeArrayField(ctx, "authorizationExemption", m.GetAuthorizationExemption(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'authorizationExemption' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAuthorizationExemptions"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAuthorizationExemptions")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAuthorizationExemptions) IsBACnetConstructedDataAuthorizationExemptions() {
}

func (m *_BACnetConstructedDataAuthorizationExemptions) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAuthorizationExemptions) deepCopy() *_BACnetConstructedDataAuthorizationExemptions {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAuthorizationExemptionsCopy := &_BACnetConstructedDataAuthorizationExemptions{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetAuthorizationExemptionTagged, BACnetAuthorizationExemptionTagged](m.AuthorizationExemption),
	}
	_BACnetConstructedDataAuthorizationExemptionsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAuthorizationExemptionsCopy
}

func (m *_BACnetConstructedDataAuthorizationExemptions) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
