/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetSecurityKeySet is the corresponding interface of BACnetSecurityKeySet
type BACnetSecurityKeySet interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetKeyRevision returns KeyRevision (property field)
	GetKeyRevision() BACnetContextTagUnsignedInteger
	// GetActivationTime returns ActivationTime (property field)
	GetActivationTime() BACnetDateTimeEnclosed
	// GetExpirationTime returns ExpirationTime (property field)
	GetExpirationTime() BACnetDateTimeEnclosed
	// GetKeyIds returns KeyIds (property field)
	GetKeyIds() BACnetSecurityKeySetKeyIds
	// IsBACnetSecurityKeySet is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetSecurityKeySet()
	// CreateBuilder creates a BACnetSecurityKeySetBuilder
	CreateBACnetSecurityKeySetBuilder() BACnetSecurityKeySetBuilder
}

// _BACnetSecurityKeySet is the data-structure of this message
type _BACnetSecurityKeySet struct {
	KeyRevision    BACnetContextTagUnsignedInteger
	ActivationTime BACnetDateTimeEnclosed
	ExpirationTime BACnetDateTimeEnclosed
	KeyIds         BACnetSecurityKeySetKeyIds
}

var _ BACnetSecurityKeySet = (*_BACnetSecurityKeySet)(nil)

// NewBACnetSecurityKeySet factory function for _BACnetSecurityKeySet
func NewBACnetSecurityKeySet(keyRevision BACnetContextTagUnsignedInteger, activationTime BACnetDateTimeEnclosed, expirationTime BACnetDateTimeEnclosed, keyIds BACnetSecurityKeySetKeyIds) *_BACnetSecurityKeySet {
	if keyRevision == nil {
		panic("keyRevision of type BACnetContextTagUnsignedInteger for BACnetSecurityKeySet must not be nil")
	}
	if activationTime == nil {
		panic("activationTime of type BACnetDateTimeEnclosed for BACnetSecurityKeySet must not be nil")
	}
	if expirationTime == nil {
		panic("expirationTime of type BACnetDateTimeEnclosed for BACnetSecurityKeySet must not be nil")
	}
	if keyIds == nil {
		panic("keyIds of type BACnetSecurityKeySetKeyIds for BACnetSecurityKeySet must not be nil")
	}
	return &_BACnetSecurityKeySet{KeyRevision: keyRevision, ActivationTime: activationTime, ExpirationTime: expirationTime, KeyIds: keyIds}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetSecurityKeySetBuilder is a builder for BACnetSecurityKeySet
type BACnetSecurityKeySetBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(keyRevision BACnetContextTagUnsignedInteger, activationTime BACnetDateTimeEnclosed, expirationTime BACnetDateTimeEnclosed, keyIds BACnetSecurityKeySetKeyIds) BACnetSecurityKeySetBuilder
	// WithKeyRevision adds KeyRevision (property field)
	WithKeyRevision(BACnetContextTagUnsignedInteger) BACnetSecurityKeySetBuilder
	// WithKeyRevisionBuilder adds KeyRevision (property field) which is build by the builder
	WithKeyRevisionBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetSecurityKeySetBuilder
	// WithActivationTime adds ActivationTime (property field)
	WithActivationTime(BACnetDateTimeEnclosed) BACnetSecurityKeySetBuilder
	// WithActivationTimeBuilder adds ActivationTime (property field) which is build by the builder
	WithActivationTimeBuilder(func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetSecurityKeySetBuilder
	// WithExpirationTime adds ExpirationTime (property field)
	WithExpirationTime(BACnetDateTimeEnclosed) BACnetSecurityKeySetBuilder
	// WithExpirationTimeBuilder adds ExpirationTime (property field) which is build by the builder
	WithExpirationTimeBuilder(func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetSecurityKeySetBuilder
	// WithKeyIds adds KeyIds (property field)
	WithKeyIds(BACnetSecurityKeySetKeyIds) BACnetSecurityKeySetBuilder
	// WithKeyIdsBuilder adds KeyIds (property field) which is build by the builder
	WithKeyIdsBuilder(func(BACnetSecurityKeySetKeyIdsBuilder) BACnetSecurityKeySetKeyIdsBuilder) BACnetSecurityKeySetBuilder
	// Build builds the BACnetSecurityKeySet or returns an error if something is wrong
	Build() (BACnetSecurityKeySet, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetSecurityKeySet
}

// NewBACnetSecurityKeySetBuilder() creates a BACnetSecurityKeySetBuilder
func NewBACnetSecurityKeySetBuilder() BACnetSecurityKeySetBuilder {
	return &_BACnetSecurityKeySetBuilder{_BACnetSecurityKeySet: new(_BACnetSecurityKeySet)}
}

type _BACnetSecurityKeySetBuilder struct {
	*_BACnetSecurityKeySet

	collectedErr []error
}

var _ (BACnetSecurityKeySetBuilder) = (*_BACnetSecurityKeySetBuilder)(nil)

func (b *_BACnetSecurityKeySetBuilder) WithMandatoryFields(keyRevision BACnetContextTagUnsignedInteger, activationTime BACnetDateTimeEnclosed, expirationTime BACnetDateTimeEnclosed, keyIds BACnetSecurityKeySetKeyIds) BACnetSecurityKeySetBuilder {
	return b.WithKeyRevision(keyRevision).WithActivationTime(activationTime).WithExpirationTime(expirationTime).WithKeyIds(keyIds)
}

func (b *_BACnetSecurityKeySetBuilder) WithKeyRevision(keyRevision BACnetContextTagUnsignedInteger) BACnetSecurityKeySetBuilder {
	b.KeyRevision = keyRevision
	return b
}

func (b *_BACnetSecurityKeySetBuilder) WithKeyRevisionBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetSecurityKeySetBuilder {
	builder := builderSupplier(b.KeyRevision.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.KeyRevision, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetSecurityKeySetBuilder) WithActivationTime(activationTime BACnetDateTimeEnclosed) BACnetSecurityKeySetBuilder {
	b.ActivationTime = activationTime
	return b
}

func (b *_BACnetSecurityKeySetBuilder) WithActivationTimeBuilder(builderSupplier func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetSecurityKeySetBuilder {
	builder := builderSupplier(b.ActivationTime.CreateBACnetDateTimeEnclosedBuilder())
	var err error
	b.ActivationTime, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDateTimeEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetSecurityKeySetBuilder) WithExpirationTime(expirationTime BACnetDateTimeEnclosed) BACnetSecurityKeySetBuilder {
	b.ExpirationTime = expirationTime
	return b
}

func (b *_BACnetSecurityKeySetBuilder) WithExpirationTimeBuilder(builderSupplier func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetSecurityKeySetBuilder {
	builder := builderSupplier(b.ExpirationTime.CreateBACnetDateTimeEnclosedBuilder())
	var err error
	b.ExpirationTime, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDateTimeEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetSecurityKeySetBuilder) WithKeyIds(keyIds BACnetSecurityKeySetKeyIds) BACnetSecurityKeySetBuilder {
	b.KeyIds = keyIds
	return b
}

func (b *_BACnetSecurityKeySetBuilder) WithKeyIdsBuilder(builderSupplier func(BACnetSecurityKeySetKeyIdsBuilder) BACnetSecurityKeySetKeyIdsBuilder) BACnetSecurityKeySetBuilder {
	builder := builderSupplier(b.KeyIds.CreateBACnetSecurityKeySetKeyIdsBuilder())
	var err error
	b.KeyIds, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetSecurityKeySetKeyIdsBuilder failed"))
	}
	return b
}

func (b *_BACnetSecurityKeySetBuilder) Build() (BACnetSecurityKeySet, error) {
	if b.KeyRevision == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'keyRevision' not set"))
	}
	if b.ActivationTime == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'activationTime' not set"))
	}
	if b.ExpirationTime == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'expirationTime' not set"))
	}
	if b.KeyIds == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'keyIds' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetSecurityKeySet.deepCopy(), nil
}

func (b *_BACnetSecurityKeySetBuilder) MustBuild() BACnetSecurityKeySet {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetSecurityKeySetBuilder) DeepCopy() any {
	_copy := b.CreateBACnetSecurityKeySetBuilder().(*_BACnetSecurityKeySetBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetSecurityKeySetBuilder creates a BACnetSecurityKeySetBuilder
func (b *_BACnetSecurityKeySet) CreateBACnetSecurityKeySetBuilder() BACnetSecurityKeySetBuilder {
	if b == nil {
		return NewBACnetSecurityKeySetBuilder()
	}
	return &_BACnetSecurityKeySetBuilder{_BACnetSecurityKeySet: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetSecurityKeySet) GetKeyRevision() BACnetContextTagUnsignedInteger {
	return m.KeyRevision
}

func (m *_BACnetSecurityKeySet) GetActivationTime() BACnetDateTimeEnclosed {
	return m.ActivationTime
}

func (m *_BACnetSecurityKeySet) GetExpirationTime() BACnetDateTimeEnclosed {
	return m.ExpirationTime
}

func (m *_BACnetSecurityKeySet) GetKeyIds() BACnetSecurityKeySetKeyIds {
	return m.KeyIds
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetSecurityKeySet(structType any) BACnetSecurityKeySet {
	if casted, ok := structType.(BACnetSecurityKeySet); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetSecurityKeySet); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetSecurityKeySet) GetTypeName() string {
	return "BACnetSecurityKeySet"
}

func (m *_BACnetSecurityKeySet) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (keyRevision)
	lengthInBits += m.KeyRevision.GetLengthInBits(ctx)

	// Simple field (activationTime)
	lengthInBits += m.ActivationTime.GetLengthInBits(ctx)

	// Simple field (expirationTime)
	lengthInBits += m.ExpirationTime.GetLengthInBits(ctx)

	// Simple field (keyIds)
	lengthInBits += m.KeyIds.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetSecurityKeySet) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetSecurityKeySetParse(ctx context.Context, theBytes []byte) (BACnetSecurityKeySet, error) {
	return BACnetSecurityKeySetParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetSecurityKeySetParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetSecurityKeySet, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetSecurityKeySet, error) {
		return BACnetSecurityKeySetParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetSecurityKeySetParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetSecurityKeySet, error) {
	v, err := (&_BACnetSecurityKeySet{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetSecurityKeySet) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetSecurityKeySet BACnetSecurityKeySet, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetSecurityKeySet"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetSecurityKeySet")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	keyRevision, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "keyRevision", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'keyRevision' field"))
	}
	m.KeyRevision = keyRevision

	activationTime, err := ReadSimpleField[BACnetDateTimeEnclosed](ctx, "activationTime", ReadComplex[BACnetDateTimeEnclosed](BACnetDateTimeEnclosedParseWithBufferProducer((uint8)(uint8(1))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'activationTime' field"))
	}
	m.ActivationTime = activationTime

	expirationTime, err := ReadSimpleField[BACnetDateTimeEnclosed](ctx, "expirationTime", ReadComplex[BACnetDateTimeEnclosed](BACnetDateTimeEnclosedParseWithBufferProducer((uint8)(uint8(2))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'expirationTime' field"))
	}
	m.ExpirationTime = expirationTime

	keyIds, err := ReadSimpleField[BACnetSecurityKeySetKeyIds](ctx, "keyIds", ReadComplex[BACnetSecurityKeySetKeyIds](BACnetSecurityKeySetKeyIdsParseWithBufferProducer((uint8)(uint8(3))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'keyIds' field"))
	}
	m.KeyIds = keyIds

	if closeErr := readBuffer.CloseContext("BACnetSecurityKeySet"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetSecurityKeySet")
	}

	return m, nil
}

func (m *_BACnetSecurityKeySet) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetSecurityKeySet) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetSecurityKeySet"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetSecurityKeySet")
	}

	if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "keyRevision", m.GetKeyRevision(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'keyRevision' field")
	}

	if err := WriteSimpleField[BACnetDateTimeEnclosed](ctx, "activationTime", m.GetActivationTime(), WriteComplex[BACnetDateTimeEnclosed](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'activationTime' field")
	}

	if err := WriteSimpleField[BACnetDateTimeEnclosed](ctx, "expirationTime", m.GetExpirationTime(), WriteComplex[BACnetDateTimeEnclosed](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'expirationTime' field")
	}

	if err := WriteSimpleField[BACnetSecurityKeySetKeyIds](ctx, "keyIds", m.GetKeyIds(), WriteComplex[BACnetSecurityKeySetKeyIds](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'keyIds' field")
	}

	if popErr := writeBuffer.PopContext("BACnetSecurityKeySet"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetSecurityKeySet")
	}
	return nil
}

func (m *_BACnetSecurityKeySet) IsBACnetSecurityKeySet() {}

func (m *_BACnetSecurityKeySet) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetSecurityKeySet) deepCopy() *_BACnetSecurityKeySet {
	if m == nil {
		return nil
	}
	_BACnetSecurityKeySetCopy := &_BACnetSecurityKeySet{
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.KeyRevision),
		utils.DeepCopy[BACnetDateTimeEnclosed](m.ActivationTime),
		utils.DeepCopy[BACnetDateTimeEnclosed](m.ExpirationTime),
		utils.DeepCopy[BACnetSecurityKeySetKeyIds](m.KeyIds),
	}
	return _BACnetSecurityKeySetCopy
}

func (m *_BACnetSecurityKeySet) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
