/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.w3c.domts.DOMTest.load;


/**
 * The createDocument method with valid arguments, should create a DOM Document of
 * the specified type.
 * <p>
 * Call the createDocument on this DOMImplementation with
 * createDocument ("http://www.w3.org/DOMTest/L2",see the array below for valid QNames,null).
 * Check if the returned Document object is is empty with no Document Element.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Level-2-Core-DOM-createDocument">http://www.w3.org/TR/DOM-Level-2-Core/core#Level-2-Core-DOM-createDocument</a>
 */
public class domimplementationcreatedocument03 {
    @Test
    void testRun() throws Throwable {
        DocumentType docType = null;
        String namespaceURI = "http://www.w3.org/DOMTest/L2";

        String[] qualifiedNames = {
            "_:_", "_:h0", "_:test", "l_:_", "ns:_0", "ns:a0", "ns0:test", "a.b:c", "a-b:c", "a-b:c" /* , "a.b:c" */
        };

        Document doc = load("staffNS", false);
        DOMImplementation domImpl = doc.getImplementation();
        for (String qualifiedName : qualifiedNames) {
            Document newDoc = domImpl.createDocument(namespaceURI, qualifiedName, docType);
            assertNotNull(newDoc, "domimplementationcreatedocument03");
        }
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/domimplementationcreatedocument03";
    }

}
