/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.notifications;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
public class NewJobSender
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private JobManagerConfiguration configuration;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private EventAdmin eventAdmin;
    private volatile ServiceRegistration<ResourceChangeListener> listenerRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "Apache Sling Job Topic Manager Event Handler");
        ((Dictionary)properties).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)properties).put("resource.change.types", ResourceChange.ChangeType.ADDED.toString());
        ((Dictionary)properties).put("resource.paths", this.configuration.getLocalJobsPath());
        this.listenerRegistration = bundleContext.registerService(ResourceChangeListener.class, (Object)this, properties);
        this.logger.debug("Registered resource event listener for {}", (Object)this.configuration.getLocalJobsPath());
    }

    @Deactivate
    protected void deactivate() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.unregister();
            this.listenerRegistration = null;
        }
        this.logger.debug("Deactivating resource event listener");
    }

    public void onChange(List<ResourceChange> resourceChanges) {
        for (ResourceChange resourceChange : resourceChanges) {
            String path = resourceChange.getPath();
            this.logger.debug("Received event {} : {}", (Object)resourceChange.getType().name(), (Object)path);
            int topicStart = this.configuration.getLocalJobsPath().length() + 1;
            int topicEnd = path.indexOf(47, topicStart);
            if (topicEnd == -1) continue;
            String topic = path.substring(topicStart, topicEnd).replace('.', '/');
            String jobId = path.substring(topicEnd + 1);
            if (path.indexOf("_", topicEnd + 1) == -1) continue;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("slingevent:eventId", jobId);
            ((Dictionary)properties).put("event.job.topic", topic);
            String queueName = this.configuration.getQueueConfigurationManager().getQueueInfo((String)topic).queueName;
            ((Dictionary)properties).put("event.job.queuename", queueName);
            Event jobEvent = new Event("org/apache/sling/event/notification/job/ADDED", properties);
            this.logger.debug("Sending event {} : {}", (Object)topic, (Object)jobId);
            this.eventAdmin.sendEvent(jobEvent);
        }
    }
}

