/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.io.InputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.NodeId;

public class WorkspaceImport
extends AbstractOperation {
    private final NodeState nodeState;
    private final InputStream xmlStream;
    private final int uuidBehaviour;

    private WorkspaceImport(NodeState nodeState, InputStream xmlStream, int uuidBehaviour) {
        if (nodeState == null || xmlStream == null) {
            throw new IllegalArgumentException();
        }
        this.nodeState = nodeState;
        this.xmlStream = xmlStream;
        this.uuidBehaviour = uuidBehaviour;
    }

    @Override
    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    @Override
    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        if (this.uuidBehaviour == 1 || this.uuidBehaviour == 2) {
            NodeEntry entry = this.nodeState.getNodeEntry();
            while (entry.getParent() != null) {
                entry = entry.getParent();
            }
            entry.invalidate(true);
        } else {
            this.nodeState.getNodeEntry().invalidate(false);
        }
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeId();
    }

    public InputStream getXmlStream() {
        return this.xmlStream;
    }

    public int getUuidBehaviour() {
        return this.uuidBehaviour;
    }

    public static Operation create(NodeState nodeState, InputStream xmlStream, int uuidBehaviour) {
        return new WorkspaceImport(nodeState, xmlStream, uuidBehaviour);
    }
}

