/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.junit;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.ConfigAnnotationUtil;
import org.apache.sling.testing.mock.osgi.config.ConfigTypeContext;
import org.apache.sling.testing.mock.osgi.config.annotations.AutoConfig;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigCollection;
import org.apache.sling.testing.mock.osgi.config.annotations.TypedConfig;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ConfigCollector
implements TestRule,
ConfigCollection {
    private static final ConfigAnnotationUtil.ConfigTypePredicate DEFAULT_CONFIG_TYPE_PREDICATE = (parent, configType) -> !configType.getPackageName().startsWith("org.junit");
    private final ConfigTypeContext configTypeContext;
    private final String applyPid;
    private Context context = null;

    public ConfigCollector(@NotNull OsgiContextImpl osgiContext) {
        this(osgiContext, null, null);
    }

    public ConfigCollector(@NotNull OsgiContextImpl osgiContext, @NotNull String pid) {
        this(osgiContext, null, pid);
    }

    public ConfigCollector(@NotNull OsgiContextImpl osgiContext, @NotNull Class component) {
        this(osgiContext, component, null);
    }

    public ConfigCollector(@NotNull OsgiContextImpl osgiContext, @Nullable Class component, @Nullable String pid) {
        this.configTypeContext = new ConfigTypeContext(osgiContext);
        this.applyPid = this.configTypeContext.getConfigurationPid(Optional.ofNullable(pid).orElse("$"), Optional.ofNullable(component).orElse(Void.class)).orElse(null);
    }

    public Stream<TypedConfig> stream() {
        return Optional.ofNullable(this.context).stream().flatMap(Context::stream);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ConfigCollector.this.context = new Context(description);
                try {
                    base.evaluate();
                }
                finally {
                    ConfigCollector.this.context = null;
                }
            }
        };
    }

    void processSetConfigAnnotations(@NotNull Description description) {
        ArrayList<Annotation> updateAnnotations = new ArrayList<Annotation>(Arrays.asList(description.getTestClass().getAnnotations()));
        updateAnnotations.addAll(description.getAnnotations());
        ConfigAnnotationUtil.findUpdateConfigAnnotations(updateAnnotations).forEachOrdered(arg_0 -> ((ConfigTypeContext)this.configTypeContext).updateConfiguration(arg_0));
    }

    void processAutoConfigAnnotation(@NotNull Description description) {
        String autoPid = Optional.ofNullable((AutoConfig)description.getAnnotation(AutoConfig.class)).or(() -> Optional.ofNullable(description.getTestClass().getAnnotation(AutoConfig.class))).flatMap(autoConfig -> this.configTypeContext.getConfigurationPid(autoConfig.pid(), autoConfig.value())).orElse(null);
        if (autoPid != null) {
            ArrayList<Annotation> unboundConfigTypes = new ArrayList<Annotation>(Arrays.asList(description.getTestClass().getAnnotations()));
            unboundConfigTypes.addAll(description.getAnnotations());
            HashMap accumulator = new HashMap();
            ConfigAnnotationUtil.findConfigTypeAnnotations(unboundConfigTypes, DEFAULT_CONFIG_TYPE_PREDICATE.and((annotation, configType) -> annotation.map(some -> this.configTypeContext.getConfigurationPid(some.pid(), some.component())).isEmpty())::test).map(annotation -> this.configTypeContext.newTypedConfig(annotation).getConfigMap()).forEachOrdered(accumulator::putAll);
            this.configTypeContext.updateConfiguration(autoPid, accumulator);
        }
    }

    List<TypedConfig> collectTypedConfigs(@NotNull Description description) {
        ArrayList<Annotation> applyAnnotations = new ArrayList<Annotation>(description.getAnnotations());
        applyAnnotations.addAll(Arrays.asList(description.getTestClass().getAnnotations()));
        return ConfigAnnotationUtil.findConfigTypeAnnotations(applyAnnotations, (ConfigAnnotationUtil.ConfigTypePredicate)DEFAULT_CONFIG_TYPE_PREDICATE).map(annotation -> this.configTypeContext.newTypedConfig(annotation, this.applyPid)).collect(Collectors.toList());
    }

    private class Context
    implements ConfigCollection {
        private final List<TypedConfig> entries;

        public Context(Description description) {
            ConfigCollector.this.processSetConfigAnnotations(description);
            ConfigCollector.this.processAutoConfigAnnotation(description);
            this.entries = ConfigCollector.this.collectTypedConfigs(description);
        }

        public Stream<TypedConfig> stream() {
            return this.entries.stream();
        }
    }
}

