/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.base.JRBaseSection;
import net.sf.jasperreports.engine.design.JRDesignBand;

public class JRDesignSection
extends JRBaseSection {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BANDS = "bands";
    public static final String PROPERTY_PARTS = "parts";
    protected List<JRBand> bandsList = new ArrayList<JRBand>();
    protected List<JRPart> partsList = new ArrayList<JRPart>();
    private JROrigin origin;

    public JRDesignSection() {
    }

    public JRDesignSection(JROrigin origin) {
        this.origin = origin;
    }

    @JsonIgnore
    public JROrigin getOrigin() {
        return this.origin;
    }

    @JsonIgnore
    protected void setOrigin(JROrigin origin) {
        this.origin = origin;
        if (this.bandsList != null && this.bandsList.size() > 0) {
            for (JRDesignBand jRDesignBand : this.bandsList) {
                jRDesignBand.setOrigin(origin);
            }
        }
    }

    @Override
    public JRBand[] getBands() {
        JRBand[] bandsArray = new JRBand[this.bandsList.size()];
        this.bandsList.toArray(bandsArray);
        return bandsArray;
    }

    @JsonIgnore
    public List<JRBand> getBandsList() {
        return this.bandsList;
    }

    @JsonSetter
    private void setBands(List<JRBand> bands) {
        if (bands != null) {
            for (JRBand band : bands) {
                this.addBand(band);
            }
        }
    }

    public void addBand(JRBand band) {
        ((JRDesignBand)band).setOrigin(this.getOrigin());
        this.bandsList.add(band);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_BANDS, band, this.bandsList.size() - 1);
    }

    public void addBand(int index, JRBand band) {
        ((JRDesignBand)band).setOrigin(this.getOrigin());
        this.bandsList.add(index, band);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_BANDS, band, index);
    }

    public JRBand removeBand(JRBand band) {
        int idx;
        if (band != null && (idx = this.bandsList.indexOf(band)) >= 0) {
            this.bandsList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_BANDS, band, idx);
        }
        return band;
    }

    public JRBand removeBand(int index) {
        JRBand band = this.bandsList.remove(index);
        this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_BANDS, band, index);
        return band;
    }

    @Override
    public JRPart[] getParts() {
        JRPart[] partsArray = new JRPart[this.partsList.size()];
        this.partsList.toArray(partsArray);
        return partsArray;
    }

    @JsonIgnore
    public List<JRPart> getPartsList() {
        return this.partsList;
    }

    @JsonSetter
    private void setParts(List<JRPart> parts) {
        if (parts != null) {
            for (JRPart part : parts) {
                this.addPart(part);
            }
        }
    }

    public void addPart(JRPart part) {
        this.partsList.add(part);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARTS, part, this.partsList.size() - 1);
    }

    public void addPart(int index, JRPart part) {
        this.partsList.add(index, part);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARTS, part, index);
    }

    public JRPart removePart(JRPart part) {
        int idx;
        if (part != null && (idx = this.partsList.indexOf(part)) >= 0) {
            this.partsList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARTS, part, idx);
        }
        return part;
    }

    public JRPart removePart(int index) {
        JRPart part = this.partsList.remove(index);
        this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARTS, part, index);
        return part;
    }
}

