/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.api;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.struts2.util.TextParseUtil;
import org.apache.tiles.api.Expression;
import org.apache.tiles.request.Request;

public class Attribute {
    private static final String TEMPLATE_RENDERER = "template";
    private Set<String> roles = null;
    private Object value = null;
    private Expression expressionObject = null;
    private String renderer = null;

    public Attribute() {
    }

    public Attribute(Object value) {
        this.value = value;
    }

    public Attribute(Attribute attribute) {
        this.roles = attribute.roles;
        this.value = attribute.getValue();
        this.expressionObject = attribute.expressionObject != null ? new Expression(attribute.expressionObject) : null;
        this.renderer = attribute.renderer;
    }

    public Attribute(Object value, String role) {
        this.value = value;
        this.setRole(role);
    }

    public Attribute(Object value, Expression expression, String role, String rendererName) {
        this.value = value;
        this.expressionObject = expression;
        this.renderer = rendererName;
        this.setRole(role);
    }

    public static Attribute createTemplateAttribute(String template) {
        Attribute attribute = new Attribute();
        attribute.setValue(template);
        attribute.setRenderer(TEMPLATE_RENDERER);
        return attribute;
    }

    public static Attribute createTemplateAttribute(String template, String templateExpression, String templateType, String role) {
        Attribute templateAttribute = Attribute.createTemplateAttribute(template);
        templateAttribute.setRole(role);
        if (templateType != null) {
            templateAttribute.setRenderer(templateType);
        }
        templateAttribute.setExpressionObject(Expression.createExpressionFromDescribedExpression(templateExpression));
        return templateAttribute;
    }

    public String getRole() {
        String retValue = null;
        if (this.roles != null && !this.roles.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            Iterator<String> roleIt = this.roles.iterator();
            if (roleIt.hasNext()) {
                builder.append(roleIt.next());
                while (roleIt.hasNext()) {
                    builder.append(",");
                    builder.append(roleIt.next());
                }
                retValue = builder.toString();
            }
        }
        return retValue;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRole(String role) {
        this.roles = role != null && role.trim().length() > 0 ? TextParseUtil.commaDelimitedStringToSet((String)role) : null;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Expression getExpressionObject() {
        return this.expressionObject;
    }

    public void setExpressionObject(Expression expressionObject) {
        this.expressionObject = expressionObject;
    }

    public String toString() {
        return Objects.toString(this.value);
    }

    public String getRenderer() {
        return this.renderer;
    }

    public void setRenderer(String rendererName) {
        this.renderer = rendererName;
    }

    public void inherit(Attribute attribute) {
        Expression targetExpressionObject;
        if (this.value == null) {
            this.value = attribute.getValue();
        }
        if ((targetExpressionObject = attribute.getExpressionObject()) != null && (this.expressionObject == null || this.expressionObject.getExpression() == null)) {
            this.expressionObject = new Expression(targetExpressionObject);
        }
        if (this.roles == null || this.roles.isEmpty()) {
            this.roles = attribute.getRoles();
        }
        if (this.renderer == null) {
            this.renderer = attribute.getRenderer();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null && this.value == null) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)obj;
        return Objects.equals(this.value, attribute.value) && Objects.equals(this.renderer, attribute.renderer) && Objects.equals(this.roles, attribute.roles) && Objects.equals(this.expressionObject, attribute.expressionObject);
    }

    public boolean isPermitted(Request request) {
        if (this.roles == null || this.roles.isEmpty()) {
            return true;
        }
        boolean retValue = false;
        Iterator<String> roleIt = this.roles.iterator();
        while (roleIt.hasNext() && !retValue) {
            retValue = request.isUserInRole(roleIt.next());
        }
        return retValue;
    }

    public int hashCode() {
        return Objects.hashCode(this.value) + Objects.hashCode(this.renderer) + Objects.hashCode(this.roles) + Objects.hashCode(this.expressionObject);
    }

    public Attribute copy() {
        return new Attribute(this);
    }
}

