/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.collection;

import java.util.Map;
import java.util.Objects;
import org.apache.tiles.request.collection.MapEntry;

public class MapEntryArrayValues<K, V>
extends MapEntry<K, V[]> {
    public MapEntryArrayValues(K key, V[] value, boolean modifiable) {
        super(key, value, modifiable);
    }

    @Override
    public int hashCode() {
        int valueHash = 0;
        Object[] value = (Object[])this.getValue();
        if (value != null) {
            for (Object v : value) {
                valueHash += v.hashCode();
            }
        }
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ valueHash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) return false;
        Map.Entry entry = (Map.Entry)o;
        if (this.getKey() == null) {
            if (entry.getKey() != null) return false;
        } else if (!this.getKey().equals(entry.getKey())) return false;
        Object[] values = (Object[])this.getValue();
        Object[] otherValues = (Object[])entry.getValue();
        if (values != null) {
            if (otherValues == null) return false;
            if (values.length != otherValues.length) return false;
            boolean same = true;
            int i = 0;
            while (i < values.length) {
                if (!same) return same;
                same = Objects.equals(values[i], otherValues[i]);
                ++i;
            }
            return same;
        }
        if (otherValues != null) return false;
        return true;
    }
}

