/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.apache.struts2.interceptor.AbstractInterceptor;

public class DateTextFieldInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(DateTextFieldInterceptor.class);

    @Override
    public String intercept(ActionInvocation ai) throws Exception {
        HttpParameters parameters = ai.getInvocationContext().getParameters();
        HashMap<String, Map> dates = new HashMap<String, Map>();
        DateWord[] dateWords = DateWord.getAll();
        Set<String> names = parameters.keySet();
        block2: for (String name : names) {
            for (DateWord dateWord : dateWords) {
                String dateKey = "__" + dateWord.getDescription() + "_";
                if (!name.startsWith(dateKey)) continue;
                String key = name.substring(dateKey.length());
                Parameter parameter = parameters.get(name);
                if (!parameter.isDefined()) continue block2;
                Map map = dates.computeIfAbsent(key, k -> new HashMap());
                map.put(dateWord.getDateType(), parameter.getValue());
                parameters = parameters.remove(name);
                continue block2;
            }
        }
        HashMap<String, Parameter> newParams = new HashMap<String, Parameter>();
        Set dateEntries = dates.entrySet();
        for (Map.Entry entry : dateEntries) {
            Set dateFormatEntries = ((Map)entry.getValue()).entrySet();
            StringBuilder dateFormat = new StringBuilder();
            StringBuilder dateValue = new StringBuilder();
            for (Map.Entry entry2 : dateFormatEntries) {
                dateFormat.append((String)entry2.getKey()).append("__");
                dateValue.append((String)entry2.getValue()).append("__");
            }
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(dateFormat.toString());
                formatter.setLenient(false);
                Date date = formatter.parse(dateValue.toString());
                newParams.put((String)entry.getKey(), new Parameter.Request((String)entry.getKey(), date));
            }
            catch (ParseException e) {
                LOG.warn("Cannot parse the parameter '{}' with format '{}' and with value '{}'", entry.getKey(), (Object)dateFormat.toString(), (Object)dateValue.toString());
            }
        }
        ai.getInvocationContext().getParameters().appendAll(newParams);
        return ai.invoke();
    }

    public static enum DateWord {
        S("millisecond", 3, "SSS"),
        s("second", 2, "ss"),
        m("minute", 2, "mm"),
        H("hour", 2, "HH"),
        d("day", 2, "dd"),
        M("month", 2, "MM"),
        y("year", 4, "yyyy");

        private final String description;
        private final Integer length;
        private final String dateType;

        private DateWord(String n2, Integer l, String t) {
            this.description = n2;
            this.length = l;
            this.dateType = t;
        }

        public String getDescription() {
            return this.description;
        }

        public Integer getLength() {
            return this.length;
        }

        public String getDateType() {
            return this.dateType;
        }

        public static DateWord get(Character c) {
            return DateWord.valueOf(DateWord.class, c.toString());
        }

        public static DateWord[] getAll() {
            return DateWord.values();
        }
    }
}

