/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.ognl;

import org.apache.struts2.ognl.OgnlCache;
import org.apache.struts2.ognl.OgnlCacheFactory;
import org.apache.struts2.ognl.OgnlCaffeineCache;
import org.apache.struts2.ognl.OgnlDefaultCache;
import org.apache.struts2.ognl.OgnlLRUCache;

public class DefaultOgnlCacheFactory<Key, Value>
implements OgnlCacheFactory<Key, Value> {
    private static final int DEFAULT_INIT_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final OgnlCacheFactory.CacheType defaultCacheType;
    private final int cacheMaxSize;
    private final int initialCapacity;

    public DefaultOgnlCacheFactory(int cacheMaxSize, OgnlCacheFactory.CacheType defaultCacheType) {
        this(cacheMaxSize, defaultCacheType, 16);
    }

    public DefaultOgnlCacheFactory(int cacheMaxSize, OgnlCacheFactory.CacheType defaultCacheType, int initialCapacity) {
        this.cacheMaxSize = cacheMaxSize;
        this.defaultCacheType = defaultCacheType;
        this.initialCapacity = initialCapacity;
    }

    @Override
    public OgnlCache<Key, Value> buildOgnlCache() {
        return this.buildOgnlCache(this.getCacheMaxSize(), this.initialCapacity, 0.75f, this.defaultCacheType);
    }

    @Override
    public OgnlCache<Key, Value> buildOgnlCache(int evictionLimit, int initialCapacity, float loadFactor, OgnlCacheFactory.CacheType cacheType) {
        return switch (cacheType) {
            default -> throw new IncompatibleClassChangeError();
            case OgnlCacheFactory.CacheType.BASIC -> new OgnlDefaultCache(evictionLimit, initialCapacity, loadFactor);
            case OgnlCacheFactory.CacheType.LRU -> new OgnlLRUCache(evictionLimit, initialCapacity, loadFactor);
            case OgnlCacheFactory.CacheType.WTLFU -> new OgnlCaffeineCache(evictionLimit, initialCapacity);
        };
    }

    @Override
    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    @Override
    public OgnlCacheFactory.CacheType getDefaultCacheType() {
        return this.defaultCacheType;
    }
}

