/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public class StringTextProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<String>,
MessageBodyWriter<String> {
    private int bufferSize = 4096;

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return String.class == type;
    }

    @Override
    public String readFrom(Class<String> type, Type genType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        return IOUtils.toString(is, HttpUtils.getEncoding(mt, StandardCharsets.UTF_8.name()));
    }

    @Override
    public long getSize(String t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return String.class == type;
    }

    @Override
    public void writeTo(String obj, Class<?> type, Type genType, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        String encoding = HttpUtils.getSetEncoding(mt, headers, StandardCharsets.UTF_8.name());
        byte[] bytes = obj.getBytes(encoding);
        if (bytes.length > this.bufferSize) {
            int bl;
            for (int pos = 0; pos < bytes.length; pos += bl) {
                bl = bytes.length - pos;
                if (bl > this.bufferSize) {
                    bl = this.bufferSize;
                }
                os.write(bytes, pos, bl);
            }
        } else {
            os.write(bytes);
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

