/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.internal;

import java.util.Optional;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.util.Static;
import org.apache.sis.util.iso.Names;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public final class AttributeConvention
extends Static {
    private static final LocalName SCOPE = Names.createLocalName("Apache", null, "sis");
    public static final ScopedName IDENTIFIER_PROPERTY = Names.createScopedName(SCOPE, null, "identifier");
    public static final ScopedName GEOMETRY_PROPERTY = Names.createScopedName(SCOPE, null, "geometry");
    public static final ScopedName ENVELOPE_PROPERTY = Names.createScopedName(SCOPE, null, "envelope");
    public static final ScopedName CRS_CHARACTERISTIC = Names.createScopedName(SCOPE, null, "crs");
    public static final ScopedName UNIT_CHARACTERISTIC = Names.createScopedName(SCOPE, null, "unit");
    public static final ScopedName MAXIMAL_LENGTH_CHARACTERISTIC = Names.createScopedName(SCOPE, null, "maximalLength");
    public static final GenericName VALID_VALUES_CHARACTERISTIC = Names.createScopedName(SCOPE, null, "validValues");
    public static final String IDENTIFIER = "sis:identifier";
    public static final String GEOMETRY = "sis:geometry";
    public static final String ENVELOPE = "sis:envelope";
    public static final String CRS = "sis:crs";
    public static final String UNIT = "sis:unit";
    public static final String MAXIMAL_LENGTH = "sis:maximalLength";

    private AttributeConvention() {
    }

    public static boolean contains(GenericName name) {
        while (name instanceof ScopedName) {
            if (SCOPE.equals(((ScopedName)name).path())) {
                return true;
            }
            name = ((ScopedName)name).tail();
        }
        return false;
    }

    public static boolean hasIdentifier(DefaultFeatureType feature) {
        if (feature != null) {
            try {
                return feature.getProperty(IDENTIFIER) != null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isGeometryAttribute(AbstractIdentifiedType type) {
        Optional<DefaultAttributeType<?>> at = Features.toAttribute(type);
        return at.isPresent() && Geometries.isKnownType(at.get().getValueClass());
    }

    public static boolean characterizedByCRS(AbstractIdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, CRS, CoordinateReferenceSystem.class);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(Object attribute) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(attribute, CRS);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(DefaultFeatureType feature, AbstractIdentifiedType attribute) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(feature, attribute, CRS);
    }

    public static boolean characterizedByMaximalLength(AbstractIdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, MAXIMAL_LENGTH, Integer.class);
    }

    public static Integer getMaximalLengthCharacteristic(Object attribute) {
        return (Integer)AttributeConvention.getCharacteristic(attribute, MAXIMAL_LENGTH);
    }

    public static Integer getMaximalLengthCharacteristic(DefaultFeatureType feature, AbstractIdentifiedType attribute) {
        return (Integer)AttributeConvention.getCharacteristic(feature, attribute, MAXIMAL_LENGTH);
    }

    private static boolean hasCharacteristic(AbstractIdentifiedType type, String name, Class<?> valueClass) {
        DefaultAttributeType<?> ct;
        Optional<DefaultAttributeType<?>> at = Features.toAttribute(type);
        if (at.isPresent() && (ct = at.get().characteristics().get(name)) != null) {
            return valueClass.isAssignableFrom(ct.getValueClass());
        }
        return false;
    }

    private static Object getCharacteristic(Object attribute, String name) {
        if (attribute instanceof AbstractAttribute) {
            Object value;
            AbstractAttribute<?> at = ((AbstractAttribute)attribute).characteristics().get(name);
            if (at != null && (value = at.getValue()) != null) {
                return value;
            }
            DefaultAttributeType<?> type = ((AbstractAttribute)attribute).getType().characteristics().get(name);
            if (type != null) {
                return type.getDefaultValue();
            }
        }
        return null;
    }

    private static Object getCharacteristic(DefaultFeatureType feature, AbstractIdentifiedType property, String characteristic) {
        DefaultAttributeType<?> type;
        Optional<String> referent = Features.getLinkTarget(property);
        if (referent.isPresent() && feature != null) {
            property = feature.getProperty(referent.get());
        }
        if (property instanceof DefaultAttributeType && (type = ((DefaultAttributeType)property).characteristics().get(characteristic)) != null) {
            return type.getDefaultValue();
        }
        return null;
    }
}

