/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.ruta.explain.tree.ApplyRootNode;
import org.apache.uima.ruta.explain.tree.BlockApplyNode;
import org.apache.uima.ruta.explain.tree.ConditionNode;
import org.apache.uima.ruta.explain.tree.FailedRootNode;
import org.apache.uima.ruta.explain.tree.IExplainTreeNode;
import org.apache.uima.ruta.explain.tree.MatchedRootNode;
import org.apache.uima.ruta.explain.tree.RuleApplyNode;
import org.apache.uima.ruta.explain.tree.RuleElementMatchNode;
import org.apache.uima.ruta.explain.tree.RuleElementMatchesNode;
import org.apache.uima.ruta.explain.tree.RuleElementRootNode;
import org.apache.uima.ruta.explain.tree.RuleMatchNode;

public class ExplainTree {
    private IExplainTreeNode root;
    private Type ruleMatchType;
    private Type blockApplyType;
    private Type ruleApplyType;
    private Type ruleElementMatchType;
    private Type ruleElementMatchesType;
    private Type evaluatedConditionType;
    private Type matchedRuleMatchType;
    private Type failedRuleMatchType;

    public ExplainTree(CAS cas) {
        this(cas, -1);
    }

    public ExplainTree(CAS cas, int offset) {
        this(cas, offset, false);
        if (offset >= 0) {
            this.prune(this.root);
        }
    }

    public ExplainTree(CAS cas, int offset, boolean onlyRules) {
        this.createTree(cas, offset, onlyRules);
    }

    public IExplainTreeNode getRoot() {
        return this.root;
    }

    private void createTree(CAS cas, int offset, boolean onlyRules) {
        TypeSystem ts = cas.getTypeSystem();
        Type scriptApplyType = ts.getType("org.apache.uima.ruta.type.DebugScriptApply");
        this.blockApplyType = ts.getType("org.apache.uima.ruta.type.DebugBlockApply");
        this.ruleApplyType = ts.getType("org.apache.uima.ruta.type.DebugRuleApply");
        this.ruleMatchType = ts.getType("org.apache.uima.ruta.type.DebugRuleMatch");
        this.matchedRuleMatchType = ts.getType("org.apache.uima.ruta.type.DebugMatchedRuleMatch");
        this.failedRuleMatchType = ts.getType("org.apache.uima.ruta.type.DebugFailedRuleMatch");
        this.ruleElementMatchType = ts.getType("org.apache.uima.ruta.type.DebugRuleElementMatch");
        this.ruleElementMatchesType = ts.getType("org.apache.uima.ruta.type.DebugRuleElementMatches");
        this.evaluatedConditionType = ts.getType("org.apache.uima.ruta.type.DebugEvaluatedCondition");
        if (scriptApplyType == null) {
            return;
        }
        ArrayList scriptApplies = new ArrayList(CasUtil.select((CAS)cas, (Type)scriptApplyType));
        Collections.sort(scriptApplies, new Comparator<AnnotationFS>(){

            @Override
            public int compare(AnnotationFS o1, AnnotationFS o2) {
                Feature feature = o1.getType().getFeatureByBaseName("timestamp");
                if (feature == null || !o1.getType().equals(o2.getType())) {
                    return o1.getType().getName().compareTo(o2.getType().getName());
                }
                long l1 = o1.getLongValue(feature);
                long l2 = o2.getLongValue(feature);
                return Long.compare(l1, l2);
            }
        });
        this.root = new ApplyRootNode(null, ts);
        for (AnnotationFS scriptApply : scriptApplies) {
            this.buildTree((FeatureStructure)scriptApply, this.root, ts, offset, onlyRules);
        }
    }

    private void buildTree(FeatureStructure fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        if (this.blockApplyType != null && this.blockApplyType.equals(fs.getType())) {
            this.processBlockApply((AnnotationFS)fs, parent, ts, offset, onlyRules);
        } else if (this.ruleApplyType != null && this.ruleApplyType.equals(fs.getType())) {
            this.processRuleApply((AnnotationFS)fs, parent, ts, offset, onlyRules);
        } else if (this.matchedRuleMatchType != null && this.matchedRuleMatchType.equals(fs.getType()) || this.failedRuleMatchType != null && this.failedRuleMatchType.equals(fs.getType())) {
            this.processRuleMatch((AnnotationFS)fs, parent, ts, offset, onlyRules);
        } else if (this.ruleElementMatchesType != null && this.ruleElementMatchesType.equals(fs.getType())) {
            this.processRuleElementMatches(fs, parent, ts, offset, onlyRules);
        } else if (this.ruleElementMatchType != null && this.ruleElementMatchType.equals(fs.getType())) {
            this.processRuleElementMatch((AnnotationFS)fs, parent, ts, offset, onlyRules);
        } else if (this.evaluatedConditionType != null && this.evaluatedConditionType.equals(fs.getType())) {
            this.processEvaluatedCondition(fs, parent, ts, offset, onlyRules);
        }
    }

    private void processBlockApply(AnnotationFS fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        FeatureStructure[] fsarray;
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        BlockApplyNode blockNode = null;
        if (!onlyRules) {
            blockNode = new BlockApplyNode(parent, (FeatureStructure)fs, ts);
            parent.addChild(blockNode);
            this.processBlockRuleApply(fs, blockNode, ts, offset, onlyRules);
        }
        Feature feature = this.blockApplyType.getFeatureByBaseName("innerApply");
        FeatureStructure featureValue = fs.getFeatureValue(feature);
        ArrayFS value = (ArrayFS)featureValue;
        for (FeatureStructure each : fsarray = value.toArray()) {
            if (!onlyRules) {
                this.buildTree(each, blockNode, ts, offset, onlyRules);
                continue;
            }
            this.buildTree(each, parent, ts, offset, onlyRules);
        }
    }

    private void processBlockRuleApply(AnnotationFS fs, BlockApplyNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        RuleApplyNode ruleNode = new RuleApplyNode(parent, (FeatureStructure)fs, ts);
        parent.setBlockRuleApply(ruleNode);
        Feature feature = this.ruleApplyType.getFeatureByBaseName("rules");
        ArrayFS value = (ArrayFS)fs.getFeatureValue(feature);
        if (value == null) {
            return;
        }
        FeatureStructure[] fsarray = value.toArray();
        MatchedRootNode matched = new MatchedRootNode(ruleNode, ts);
        FailedRootNode failed = new FailedRootNode(ruleNode, ts);
        ruleNode.addChild(matched);
        ruleNode.addChild(failed);
        for (FeatureStructure eachRuleMatch : fsarray) {
            FeatureStructure[] da;
            ArrayFS dv;
            Feature f = eachRuleMatch.getType().getFeatureByBaseName("matched");
            boolean matchedValue = eachRuleMatch.getBooleanValue(f);
            if (matchedValue) {
                this.buildTree(eachRuleMatch, matched, ts, offset, onlyRules);
            } else {
                this.buildTree(eachRuleMatch, failed, ts, offset, onlyRules);
            }
            Feature df = eachRuleMatch.getType().getFeatureByBaseName("delegates");
            if (df == null || (dv = (ArrayFS)eachRuleMatch.getFeatureValue(df)) == null) continue;
            for (FeatureStructure delegateFS : da = dv.toArray()) {
                this.buildTree(delegateFS, ruleNode, ts, offset, onlyRules);
            }
        }
    }

    private void processRuleApply(AnnotationFS fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        RuleApplyNode ruleNode = new RuleApplyNode(parent, (FeatureStructure)fs, ts);
        parent.addChild(ruleNode);
        Feature feature = this.ruleApplyType.getFeatureByBaseName("rules");
        ArrayFS value = (ArrayFS)fs.getFeatureValue(feature);
        FeatureStructure[] fsarray = value.toArray();
        MatchedRootNode matched = new MatchedRootNode(ruleNode, ts);
        FailedRootNode failed = new FailedRootNode(ruleNode, ts);
        ruleNode.addChild(matched);
        ruleNode.addChild(failed);
        for (FeatureStructure eachRuleMatch : fsarray) {
            FeatureStructure[] da;
            ArrayFS dv;
            Feature f = eachRuleMatch.getType().getFeatureByBaseName("matched");
            boolean matchedValue = eachRuleMatch.getBooleanValue(f);
            if (matchedValue) {
                this.buildTree(eachRuleMatch, matched, ts, offset, onlyRules);
            } else {
                this.buildTree(eachRuleMatch, failed, ts, offset, onlyRules);
            }
            Feature df = eachRuleMatch.getType().getFeatureByBaseName("delegates");
            if (df == null || (dv = (ArrayFS)eachRuleMatch.getFeatureValue(df)) == null) continue;
            for (FeatureStructure delegateFS : da = dv.toArray()) {
                this.buildTree(delegateFS, ruleNode, ts, offset, onlyRules);
            }
        }
    }

    private void processRuleMatch(AnnotationFS fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        RuleMatchNode matchNode = new RuleMatchNode(parent, (FeatureStructure)fs, ts);
        parent.addChild(matchNode);
        RuleElementRootNode remRoot = new RuleElementRootNode(matchNode, ts);
        matchNode.addChild(remRoot);
        Feature feature = this.ruleMatchType.getFeatureByBaseName("elements");
        ArrayFS value = (ArrayFS)fs.getFeatureValue(feature);
        if (value != null) {
            FeatureStructure[] fsarray;
            for (FeatureStructure each : fsarray = value.toArray()) {
                this.buildTree(each, remRoot, ts, offset, onlyRules);
            }
        }
    }

    private void processRuleElementMatches(FeatureStructure fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        FeatureStructure[] fsarray;
        RuleElementMatchesNode remsNode = new RuleElementMatchesNode(parent, fs, ts);
        parent.addChild(remsNode);
        Feature feature = this.ruleElementMatchesType.getFeatureByBaseName("matches");
        ArrayFS value = (ArrayFS)fs.getFeatureValue(feature);
        for (FeatureStructure each : fsarray = value.toArray()) {
            this.buildTree(each, remsNode, ts, offset, onlyRules);
        }
    }

    private void processRuleElementMatch(AnnotationFS fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        FeatureStructure[] fsarray;
        if (offset >= 0 && (fs.getBegin() >= offset || fs.getEnd() <= offset)) {
            return;
        }
        RuleElementMatchNode remNode = new RuleElementMatchNode(parent, (FeatureStructure)fs, ts);
        parent.addChild(remNode);
        Feature feature = this.ruleElementMatchType.getFeatureByBaseName("baseCondition");
        FeatureStructure base = fs.getFeatureValue(feature);
        this.buildTree(base, remNode, ts, offset, onlyRules);
        feature = this.ruleElementMatchType.getFeatureByBaseName("conditions");
        ArrayFS value = (ArrayFS)fs.getFeatureValue(feature);
        if (value != null) {
            for (FeatureStructure each : fsarray = value.toArray()) {
                this.buildTree(each, remNode, ts, offset, onlyRules);
            }
        }
        if ((value = (ArrayFS)fs.getFeatureValue(feature = fs.getType().getFeatureByBaseName("elements"))) != null) {
            for (FeatureStructure each : fsarray = value.toArray()) {
                this.buildTree(each, remNode, ts, offset, onlyRules);
            }
        }
    }

    private void processEvaluatedCondition(FeatureStructure fs, IExplainTreeNode parent, TypeSystem ts, int offset, boolean onlyRules) {
        ConditionNode condNode = new ConditionNode(parent, fs, ts);
        parent.addChild(condNode);
        Feature feature = this.evaluatedConditionType.getFeatureByBaseName("conditions");
        ArrayFS value = (ArrayFS)fs.getFeatureValue(feature);
        if (value != null) {
            FeatureStructure[] fsarray;
            for (FeatureStructure each : fsarray = value.toArray()) {
                this.buildTree(each, condNode, ts, offset, onlyRules);
            }
        }
    }

    private void prune(IExplainTreeNode node) {
        if (node == null) {
            return;
        }
        List<IExplainTreeNode> children = node.getChildren();
        IExplainTreeNode parent = node.getParent();
        for (IExplainTreeNode each : new ArrayList<IExplainTreeNode>(children)) {
            this.prune(each);
        }
        if (!(node instanceof ApplyRootNode || node instanceof BlockApplyNode || node instanceof ConditionNode)) {
            if (node instanceof FailedRootNode) {
                if (!node.hasChildren()) {
                    parent.removeChild(node);
                }
            } else if (node instanceof MatchedRootNode) {
                if (!node.hasChildren()) {
                    parent.removeChild(node);
                }
            } else if (node instanceof RuleApplyNode) {
                if (!node.hasChildren()) {
                    parent.removeChild(node);
                }
            } else if (node instanceof RuleElementMatchesNode || node instanceof RuleElementMatchNode || node instanceof RuleElementRootNode || node instanceof RuleMatchNode) {
                // empty if block
            }
        }
    }
}

