/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.codeassist;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.ide.RutaIdeCorePlugin;
import org.apache.uima.ruta.ide.core.RutaExtensionManager;
import org.apache.uima.ruta.ide.core.RutaKeywordsManager;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.core.codeassist.RutaCompletionParser;
import org.apache.uima.ruta.ide.core.codeassist.RutaReferenceVisitor;
import org.apache.uima.ruta.ide.core.codeassist.TMAutoCompletionToolkit;
import org.apache.uima.ruta.ide.core.extensions.ICompletionExtension;
import org.apache.uima.ruta.ide.core.parser.RutaParseUtils;
import org.apache.uima.ruta.ide.parser.ast.ComponentDeclaration;
import org.apache.uima.ruta.ide.parser.ast.ComponentReference;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaModuleDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceModule;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class RutaCompletionEngine
extends ScriptCompletionEngine {
    protected RutaCompletionParser parser;
    protected IModuleSource sourceModule;
    protected static final boolean TRACE_COMPLETION_TIME = false;
    private ICompletionExtension[] extensions = RutaExtensionManager.getDefault().getCompletionExtensions();
    private URLClassLoader classloader = null;

    public RutaCompletionEngine() {
        this.parser = new RutaCompletionParser(this.extensions);
    }

    protected int getEndOfEmptyToken() {
        return this.actualCompletionPosition;
    }

    protected String processMethodName(IMethod method, String token) {
        return RutaParseUtils.processMethodName(method, token);
    }

    protected String processTypeName(IType type, String token) {
        return RutaParseUtils.processTypeName(type, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(IModuleSource module, int position, int i) {
        this.sourceModule = module;
        this.actualCompletionPosition = position;
        this.offset = i;
        this.requestor.beginReporting();
        String content = module.getSourceContents();
        if (position < 0 || position > content.length()) {
            return;
        }
        TMAutoCompletionToolkit tk = new TMAutoCompletionToolkit(content, position);
        String startPart = tk.getWordPrefix();
        this.setSourceRange(position - startPart.length(), position);
        RutaModuleDeclaration parsed = (RutaModuleDeclaration)this.parser.parse(module);
        if (this.classloader == null) {
            IScriptProject scriptProject = this.sourceModule.getModelElement().getScriptProject();
            try {
                Collection<String> dependencies = RutaProjectUtils.getClassPath(scriptProject.getProject());
                URL[] urls = new URL[dependencies.size()];
                int counter = 0;
                for (String dep : dependencies) {
                    urls[counter] = new File(dep).toURI().toURL();
                    ++counter;
                }
                this.classloader = new URLClassLoader(urls);
            }
            catch (MalformedURLException e) {
                RutaIdeCorePlugin.error(e);
            }
            catch (CoreException e) {
                RutaIdeCorePlugin.error(e);
            }
        }
        if (parsed != null) {
            try {
                RutaReferenceVisitor referenceVisitor = new RutaReferenceVisitor(this.actualCompletionPosition);
                parsed.traverse(referenceVisitor);
                ASTNode node = referenceVisitor.getResult();
                if (node == null) {
                    this.doCompletionOnEmptyStatement(module, position, i);
                    this.doCompletionOnDeclaration(module, startPart);
                    this.doCompletionOnVarRef(module, parsed, startPart, 0x800000, "");
                } else if (node instanceof RutaVariableReference) {
                    int type = ((RutaVariableReference)node).getType();
                    this.doCompletionOnVarRef(module, parsed, startPart, type, ((RutaVariableReference)node).getName());
                    if (RutaParseUtils.isAtLineStart(node, content)) {
                        this.doCompletionOnDeclaration(module, startPart);
                    }
                } else if (node instanceof ComponentDeclaration) {
                    this.doCompletionOnComponentDeclaration(module, parsed, startPart, ((ComponentDeclaration)node).getType(), startPart);
                } else if (node instanceof ComponentReference) {
                    this.doCompletionOnComponentReference(module, parsed, startPart, ((ComponentReference)node).getType(), startPart);
                } else if (node instanceof RutaAction) {
                    this.doCompletionOnAction(module, parsed, startPart, 0x8000000, startPart);
                    this.doCompletionOnVarRef(module, parsed, startPart, 0x800000, "");
                } else if (node instanceof RutaCondition) {
                    this.doCompletionOnCondition(module, parsed, startPart, 0x2000000, startPart);
                    this.doCompletionOnVarRef(module, parsed, startPart, 0x800000, "");
                }
            }
            catch (Exception e) {
                System.out.println("no completion node found");
            }
            finally {
                this.requestor.endReporting();
            }
        }
    }

    private void doCompletionOnComponentReference(IModuleSource cu, RutaModuleDeclaration parsed, String startPart, int type, String complString) {
        Collection importedEngines = parsed.descriptorInfo.getImportedEngines();
        importedEngines.addAll(parsed.descriptorInfo.getImportedUimafitEngines());
        for (String string : importedEngines) {
            String shortName;
            int indexOf;
            if (this.match(complString, string)) {
                this.addProposal(complString, string, 11);
            }
            if ((indexOf = string.lastIndexOf(".")) == -1 || !this.match(complString, shortName = string.substring(indexOf + 1, string.length()))) continue;
            this.addProposal(complString, shortName, 11);
        }
        Collection importedScripts = parsed.descriptorInfo.getImportedScripts();
        for (String each : importedScripts) {
            String[] split = each.split("\\.");
            String string = split[split.length - 1];
            if (!this.match(complString, string)) continue;
            this.addProposal(complString, string, 11);
        }
        ArrayList<IMethod> blocks = new ArrayList<IMethod>();
        try {
            IModelElement[] children;
            for (IModelElement iModelElement : children = this.sourceModule.getModelElement().getModel().getChildren()) {
                if (!(iModelElement instanceof SourceMethod)) continue;
                this.collectBlocks((SourceMethod)iModelElement, blocks);
            }
        }
        catch (ModelException e) {
            // empty catch block
        }
        for (IMethod m : blocks) {
            String string = m.getElementName();
            if (!this.match(complString, string)) continue;
            this.addProposal(complString, string, 11);
        }
    }

    private void doCompletionOnComponentDeclaration(IModuleSource cu, RutaModuleDeclaration parsed, String startPart, int type, String complString) throws Exception {
        if (type == ComponentDeclaration.SCRIPT) {
            Resource[] resources;
            ArrayList<String> scripts = new ArrayList<String>();
            List<IFolder> scriptFolders = RutaProjectUtils.getAllScriptFolders(this.sourceModule.getModelElement().getScriptProject());
            for (IFolder folder : scriptFolders) {
                try {
                    scripts.addAll(this.collectScripts(folder, ""));
                }
                catch (CoreException e) {}
            }
            for (Resource resource : resources = this.getFilesInClasspath(complString, "ruta")) {
                try {
                    String string = this.getScriptRepresentation(resource, "ruta");
                    if (string == null || scripts.contains(string)) continue;
                    scripts.add(string);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (String string : scripts) {
                if (!this.match(complString, string)) continue;
                this.addProposal(complString, string, 11);
            }
        } else if (type == ComponentDeclaration.UIMAFIT_ENGINE) {
            ArrayList<String> engines = new ArrayList<String>();
            ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader((ClassLoader)this.classloader);
            provider.setResourceLoader((ResourceLoader)resourceLoader);
            provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AnalysisComponent.class));
            String pack = complString.replaceAll("[.]", "/");
            if (pack.endsWith("/")) {
                pack = pack.substring(0, pack.length() - 1);
            }
            Set components = provider.findCandidateComponents(pack);
            for (BeanDefinition component : components) {
                String beanClassName = component.getBeanClassName();
                engines.add(beanClassName);
            }
            for (String string : engines) {
                if (!this.match(complString, string)) continue;
                this.addProposal(complString, string, 11);
            }
        } else if (type == ComponentDeclaration.ENGINE) {
            Resource[] resources;
            ArrayList<String> engines = new ArrayList<String>();
            for (Resource resource : resources = this.getFilesInClasspath(complString, "xml")) {
                try {
                    UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(resource.getURL()));
                    String string = this.getScriptRepresentation(resource, "xml");
                    if (string == null) continue;
                    engines.add(string);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (StringUtils.isAllUpperCase((CharSequence)complString)) {
                List<IFolder> descriptorFolders = RutaProjectUtils.getAllDescriptorFolders(this.sourceModule.getModelElement().getScriptProject().getProject());
                for (IFolder folder : descriptorFolders) {
                    try {
                        engines.addAll(this.collectEngines(folder, ""));
                    }
                    catch (CoreException e) {}
                }
            }
            for (String string : engines) {
                if (!this.match(complString, string)) continue;
                this.addProposal(complString, string, 11);
            }
        } else {
            Resource[] resources;
            ArrayList<String> tss = new ArrayList<String>();
            for (Resource resource : resources = this.getFilesInClasspath(complString, "xml")) {
                try {
                    UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(resource.getURL()));
                    String string = this.getScriptRepresentation(resource, "xml");
                    if (string == null) continue;
                    tss.add(string);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (StringUtils.isAllUpperCase((CharSequence)complString)) {
                List<IFolder> descriptorFolders = RutaProjectUtils.getAllDescriptorFolders(this.sourceModule.getModelElement().getScriptProject().getProject());
                for (IFolder folder : descriptorFolders) {
                    try {
                        tss.addAll(this.collectTypeSystems(folder, ""));
                    }
                    catch (CoreException e) {}
                }
            }
            for (String string : tss) {
                if (!this.match(complString, string)) continue;
                this.addProposal(complString, string, 11);
            }
        }
    }

    private Resource[] getFilesInClasspath(String prefix, String extension) throws IOException {
        String pack = prefix.replaceAll("[.]", "/");
        if (pack.endsWith("/")) {
            pack = pack.substring(0, pack.length() - 1);
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ClassLoader)this.classloader);
        String p = "classpath*:";
        String suffix = "/**/*." + extension;
        String pattern = p + pack + suffix;
        Resource[] resources = resolver.getResources(pattern);
        return resources;
    }

    private String getScriptRepresentation(Resource resource, String suffix) throws IOException {
        URL url = resource.getURL();
        URL[] urLs = this.classloader.getURLs();
        String externalForm = url.toExternalForm();
        for (URL each : urLs) {
            String eachExternalForm = each.toExternalForm();
            if (externalForm.startsWith("jar:")) {
                eachExternalForm = "jar:" + eachExternalForm + "!/";
            }
            if (!externalForm.startsWith(eachExternalForm)) continue;
            String name = externalForm.substring(eachExternalForm.length(), externalForm.length() - (suffix.length() + 1));
            name = name.replaceAll("[/]", ".");
            return name;
        }
        return null;
    }

    private List<String> collectEngines(IFolder folder, String prefix) throws CoreException {
        IResource[] members;
        ArrayList<String> result = new ArrayList<String>();
        for (IResource iResource : members = folder.members()) {
            File f;
            IFile file;
            if (iResource instanceof IFolder) {
                IFolder folder2 = (IFolder)iResource;
                String newPrefix = prefix + folder2.getProjectRelativePath().lastSegment() + ".";
                result.addAll(this.collectEngines(folder2, newPrefix));
                continue;
            }
            if (!(iResource instanceof IFile) || !(file = (IFile)iResource).getFileExtension().equals("xml") || !(f = new File(file.getLocation().toPortableString())).exists()) continue;
            try {
                UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(f));
                result.add(prefix + file.getName().substring(0, file.getName().length() - 4));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private List<String> collectTypeSystems(IFolder folder, String prefix) throws CoreException {
        IResource[] members;
        ArrayList<String> result = new ArrayList<String>();
        for (IResource iResource : members = folder.members()) {
            File f;
            IFile file;
            String fileExtension;
            if (iResource instanceof IFolder) {
                IFolder folder2 = (IFolder)iResource;
                String newPrefix = prefix + folder2.getProjectRelativePath().lastSegment() + ".";
                result.addAll(this.collectTypeSystems(folder2, newPrefix));
                continue;
            }
            if (!(iResource instanceof IFile) || (fileExtension = (file = (IFile)iResource).getFileExtension()) == null || !fileExtension.equals("xml") || !(f = new File(file.getLocation().toPortableString())).exists()) continue;
            try {
                UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(f));
                result.add(prefix + file.getName().substring(0, file.getName().length() - 4));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private List<String> collectScripts(IFolder folder, String prefix) throws CoreException {
        IResource[] members;
        ArrayList<String> result = new ArrayList<String>();
        for (IResource iResource : members = folder.members()) {
            IFile file;
            if (iResource instanceof IFolder) {
                IFolder folder2 = (IFolder)iResource;
                String newPrefix = prefix + folder2.getProjectRelativePath().lastSegment() + ".";
                result.addAll(this.collectScripts(folder2, newPrefix));
                continue;
            }
            if (!(iResource instanceof IFile) || !(file = (IFile)iResource).getFileExtension().equals("ruta")) continue;
            result.add(prefix + file.getName().substring(0, file.getName().length() - 5));
        }
        return result;
    }

    private void doCompletionOnDeclaration(IModuleSource cu, String startPart) {
        String[] keywords;
        for (String string : keywords = RutaKeywordsManager.getKeywords(1)) {
            if (!this.match(startPart, string)) continue;
            this.addProposal(startPart, string, 2);
        }
    }

    private Set<String> getTypes(IPath typeSystemDescriptorPath) throws InvalidXMLException, IOException {
        Set<String> types = new HashSet<String>();
        URL url = URIUtil.toURI((String)typeSystemDescriptorPath.toPortableString()).toURL();
        try {
            ResourceManager_impl resMgr = new ResourceManager_impl((ClassLoader)this.classloader);
            types = this.getTypes(url, (ResourceManager)resMgr);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return types;
    }

    private Set<String> getTypes(URL resource, ResourceManager resMgr) throws IOException, InvalidXMLException {
        HashSet<String> types = new HashSet<String>();
        TypeSystemDescription typeSysDescr = null;
        typeSysDescr = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(resource));
        typeSysDescr.resolveImports(resMgr);
        for (TypeDescription each : typeSysDescr.getTypes()) {
            String name = each.getName();
            String[] nameSpace = name.split("[.]");
            types.add(nameSpace[nameSpace.length - 1]);
            types.add(name);
        }
        return types;
    }

    private void doCompletionOnAction(IModuleSource cu, RutaModuleDeclaration parsed, String startPart, int type, String complString) {
        String[] keywords;
        for (String string : keywords = RutaKeywordsManager.getKeywords(5)) {
            if (!this.match(complString, string)) continue;
            this.addProposal(complString, string + "()", string, 10);
        }
    }

    private void doCompletionOnCondition(IModuleSource cu, RutaModuleDeclaration parsed, String startPart, int type, String complString) {
        String[] keywords;
        if (complString.startsWith("-")) {
            complString = complString.substring(1, complString.length());
        }
        for (String string : keywords = RutaKeywordsManager.getKeywords(4)) {
            if (!this.match(complString, string)) continue;
            this.addProposal(complString, string + "()", string, 10);
        }
    }

    private void doCompletionOnVarRef(IModuleSource cu, RutaModuleDeclaration parsed, String startPart, int type, String complString) {
        block8: {
            block7: {
                Set<Object> types = new HashSet();
                if (type != 0x800000) break block7;
                try {
                    IPath path = this.sourceModule.getModelElement().getResource().getLocation();
                    IPath typeSystemDescriptorPath = RutaProjectUtils.getTypeSystemDescriptorPath(path, this.sourceModule.getModelElement().getScriptProject().getProject(), this.classloader);
                    types = this.getTypes(typeSystemDescriptorPath);
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (String string : types) {
                    if (!this.match(startPart, string)) continue;
                    this.addProposal(startPart, string, 7);
                }
                break block8;
            }
            IModelElement modelElement = this.sourceModule.getModelElement();
            if (!(modelElement instanceof SourceModule)) break block8;
            SourceModule sm = (SourceModule)modelElement;
            try {
                IField[] fields;
                for (IField iField : fields = sm.getFields()) {
                    SourceField f = (SourceField)iField;
                    int fieldType = RutaParseUtils.getTypeOfIModelElement((IMember)f);
                    if (262144 == type) {
                        if (fieldType != 262144 && fieldType != 786432 && fieldType != 0x140000 && fieldType != 0x20040000) continue;
                        this.addProposal(startPart, f.getElementName(), 4);
                        continue;
                    }
                    if (type != fieldType) continue;
                    this.addProposal(startPart, f.getElementName(), 4);
                }
            }
            catch (ModelException e) {
                // empty catch block
            }
        }
    }

    private boolean match(String complString, String string) {
        return string.toLowerCase().startsWith(complString.toLowerCase()) || this.removeLowerCase(string).startsWith(complString);
    }

    private void collectBlocks(SourceMethod sm, List<IMethod> blocks) throws ModelException {
        IModelElement[] children;
        blocks.add((IMethod)sm);
        for (IModelElement me : children = sm.getChildren()) {
            if (!(me instanceof SourceMethod)) continue;
            this.collectBlocks((SourceMethod)me, blocks);
        }
    }

    private String removeLowerCase(String string) {
        String replaceAll = string.replaceAll("\\p{Lower}|[.]", "");
        return replaceAll;
    }

    private void doCompletionOnEmptyStatement(IModuleSource cu, int position, int i) {
        int kind = 4;
        if (!this.requestor.isIgnored(kind)) {
            this.suggestFields(cu);
        }
    }

    private void suggestFields(IModuleSource cu) {
    }

    private void addProposal(String complString, String string, int kind) {
        this.addProposal(complString, string, string, kind);
    }

    private void addProposal(String complString, String string, String name, int kind) {
        char[] fieldName = string.toCharArray();
        char[] complFragment = complString.toCharArray();
        char[] pattern = null;
        if (complString.length() > 0) {
            pattern = complString.toCharArray();
        }
        if (CharOperation.camelCaseMatch((char[])pattern, (char[])fieldName) || this.match(complString, string)) {
            int relevance = 1;
            relevance += this.computeRelevanceForCaseMatching(complFragment, string);
            this.noProposal = false;
            if (!this.requestor.isIgnored(kind)) {
                CompletionProposal proposal = super.createProposal(kind, this.actualCompletionPosition);
                proposal.setRelevance(relevance);
                proposal.setName(name);
                proposal.setCompletion(string);
                proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                this.requestor.accept(proposal);
                if (DEBUG) {
                    this.printDebug(proposal);
                }
            }
        }
    }
}

