/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.images.internal;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageRegistryUtil {
    private static ImageRegistryUtil instance = null;
    private ImageRegistry imageRegistry = null;
    public static final String IMG_FORM_BG = "formBg";
    public static final String IMG_LARGE = "large";
    public static final String IMG_HORIZONTAL = "th_horizontal.gif";
    public static final String IMG_VERTICAL = "vertical";
    public static final String IMG_SAMPLE = "sample";
    public static final String IMG_HELP = "help";
    public static final String IMG_VIEW_MENU = "view_menu1";
    public static final String IMG_TYPE = "type";
    public static final String IMG_TAE = "tae";
    public static final String IMG_FEATURE = "feature";
    public static final String IMG_REFRESH = "refresh";
    public static final String IMG_ADD_TYPES = "add types";
    public static final String IMG_IMPORT_TYPE = "import";
    public static final String IMG_EXPORT_TYPE = "export";
    public static final String IMG_EDIT_TYPE = "edit";
    public static final String IMG_DELETE = "delete";
    public static final String IMG_REPOSITORY = "repository";
    public static final String IMG_REPOSITORY_BIG = "repository_big";
    public static final String IMG_SEARCH = "search.gif";
    public static final String IMG_TS_FOLDER = "ts_folder";
    public static final String IMG_PEAR = "pear";
    public static final String IMG_XML = "xml";
    public static final String IMG_CHECK_IN = "checkIn";
    public static final String IMG_REPOSITORY_SYNC = "repositorySync";
    public static final String IMG_EXPAND_ALL = "expandall.gif";
    public static final String IMG_COLLAPSE_ALL = "collapseall.gif";
    public static final String IMG_FULL_NAME = "filter_history.gif";
    public static final String IMG_FILTER = "filter_history.gif";
    public static final String IMG_RUN = "o.e.debug.ui.elcl16/run_exc.gif";
    public static final String IMG_PAUSE = "o.e.debug.ui.elcl16/suspend_co.gif";
    public static final String IMG_STOP = "o.e.debug.ui.elcl16/terminate_co.gif";
    public static final String IMG_FILE_OBJ = "o.e.jdt.ui.icons.obj16/file_obj.gif";
    public static final String IMG_SEARCH_NEXT = "o.e.search.icons.elcl16/search_next.gif";
    public static final String IMG_SEARCH_PREV = "o.e.search.icons.elcl16/search_prev.gif";
    public static final String IMG_IMPORT_PREF = "o.e.ui.ide.obj16/importpref_obj.gif";

    protected ImageRegistryUtil() {
    }

    public static ImageRegistryUtil getInstance() {
        if (instance == null) {
            instance = new ImageRegistryUtil();
        }
        return instance;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_FORM_BG, "form_banner.gif");
        this.registerImage(registry, IMG_LARGE, "large_image.gif");
        this.registerImage(registry, IMG_HORIZONTAL, IMG_HORIZONTAL);
        this.registerImage(registry, IMG_VERTICAL, "th_vertical.gif");
        this.registerImage(registry, IMG_SAMPLE, "sample.gif");
        this.registerImage(registry, IMG_HELP, "help.gif");
        this.registerImage(registry, IMG_VIEW_MENU, "view_menu.gif");
        this.registerImage(registry, IMG_TAE, "tae.gif");
        this.registerImage(registry, IMG_TYPE, "type.gif");
        this.registerImage(registry, IMG_FEATURE, "final_co.gif");
        this.registerImage(registry, IMG_REFRESH, "refresh.gif");
        this.registerImage(registry, IMG_ADD_TYPES, "type_Plus.gif");
        this.registerImage(registry, IMG_IMPORT_TYPE, "import_wiz.gif");
        this.registerImage(registry, IMG_EXPORT_TYPE, "export_wiz.gif");
        this.registerImage(registry, IMG_EDIT_TYPE, "editor.gif");
        this.registerImage(registry, IMG_DELETE, "delete_obj.gif");
        this.registerImage(registry, IMG_REPOSITORY, "repo_rep.gif");
        this.registerImage(registry, IMG_REPOSITORY_BIG, "newlocation_wizban.gif");
        this.registerImage(registry, IMG_SEARCH, IMG_SEARCH);
        this.registerImage(registry, IMG_TS_FOLDER, "ts_folder.gif");
        this.registerImage(registry, IMG_PEAR, "pear.gif");
        this.registerImage(registry, IMG_XML, "xml.gif");
        this.registerImage(registry, IMG_CHECK_IN, "checkin_action.gif");
        this.registerImage(registry, IMG_REPOSITORY_SYNC, "cvs_synch.gif");
        this.registerImage(registry, IMG_EXPAND_ALL, IMG_EXPAND_ALL);
        this.registerImage(registry, IMG_COLLAPSE_ALL, IMG_COLLAPSE_ALL);
        this.registerImage(registry, "filter_history.gif", "filter_history.gif");
        this.registerImage(registry, IMG_RUN, IMG_RUN);
        this.registerImage(registry, IMG_PAUSE, IMG_PAUSE);
        this.registerImage(registry, IMG_STOP, IMG_STOP);
        this.registerImage(registry, IMG_FILE_OBJ, IMG_FILE_OBJ);
        this.registerImage(registry, IMG_SEARCH_NEXT, IMG_SEARCH_NEXT);
        this.registerImage(registry, IMG_SEARCH_PREV, IMG_SEARCH_PREV);
        this.registerImage(registry, IMG_IMPORT_PREF, IMG_IMPORT_PREF);
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            URL url = this.getClass().getClassLoader().getResource("com/ibm/uima/etools/image/icons/" + fileName);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerImage_1(ImageRegistry registry, String key, String fileName) {
        try {
            ImageDescriptor desc = ImageDescriptor.createFromFile(this.getClass(), (String)fileName);
            if (desc == null) {
                System.out.println("Cannot find: " + fileName);
                return;
            }
            registry.put(key, desc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        throw new SWTError(22);
    }

    protected ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.imageRegistry);
        }
        return this.imageRegistry;
    }
}

