/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.base_cpm.SynchPoint;
import org.apache.uima.collection.impl.cpm.BaseCPMImpl;
import org.apache.uima.collection.impl.cpm.CheckpointData;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;

public class Checkpoint
implements Runnable {
    private String fileName = null;
    private volatile boolean stop = false;
    private long checkpointFrequency = 3000L;
    private boolean pause = false;
    private final Object lockForPause = new Object();
    private BaseCPMImpl cpm = null;
    private String synchPointFileName = null;

    public Checkpoint(BaseCPMImpl aCpm, String aFilename, long aCheckpointFrequency) {
        this.fileName = aFilename;
        int fExtPos = this.fileName.indexOf(46);
        if (fExtPos > -1) {
            this.synchPointFileName = this.fileName.substring(0, fExtPos) + "_synchPoint.xml";
        }
        this.cpm = aCpm;
        this.checkpointFrequency = aCheckpointFrequency;
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        this.stop = true;
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stop_checkpoint_thread__INFO", new Object[]{Thread.currentThread().getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("CPM Checkpoint");
        while (!this.stop) {
            Object object = this.lockForPause;
            synchronized (object) {
                if (this.pause) {
                    try {
                        this.lockForPause.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkpoint__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            this.doCheckpoint();
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_sleep__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                Thread.sleep(this.checkpointFrequency);
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_wakeup__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            catch (Exception exception) {}
        }
    }

    public void delete() {
        try {
            File checkpointFile = new File(this.fileName);
            checkpointFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.lockForPause;
        synchronized (object) {
            this.pause = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lockForPause;
        synchronized (object) {
            if (this.pause) {
                this.lockForPause.notifyAll();
                this.pause = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckpoint() {
        block30: {
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkpoint__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                this.rename(this.fileName);
                this.rename(this.synchPointFileName);
                FileOutputStream out = null;
                FileOutputStream synchPointOut = null;
                ObjectOutputStream s = null;
                try {
                    out = new FileOutputStream(this.fileName);
                    synchPointOut = new FileOutputStream(this.synchPointFileName);
                    s = new ObjectOutputStream(out);
                    SynchPoint synchPoint = this.cpm.getSynchPoint();
                    ProcessTrace pTrace = this.cpm.getPerformanceReport();
                    CheckpointData targetToSave = null;
                    if (pTrace == null) break block30;
                    if (synchPoint != null) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkpoint_with_synchpoint__FINEST", new Object[]{Thread.currentThread().getName()});
                        }
                        targetToSave = new CheckpointData(pTrace, synchPoint);
                    } else {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkpoint_with_pt__FINEST", new Object[]{Thread.currentThread().getName()});
                        }
                        targetToSave = new CheckpointData(pTrace);
                    }
                    CheckpointData checkpointData = targetToSave;
                    synchronized (checkpointData) {
                        s.writeObject(targetToSave);
                        s.flush();
                        if (synchPoint != null) {
                            String xmlSynchPoint = synchPoint.serializeToXML();
                            synchPointOut.write(xmlSynchPoint.getBytes());
                            synchPointOut.flush();
                        }
                    }
                }
                catch (Exception e) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception_when_checkpointing__FINEST", new Object[]{Thread.currentThread().getName(), e.getMessage()});
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                            s.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (synchPointOut != null) {
                        try {
                            synchPointOut.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception_when_checkpointing__FINEST", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            }
        }
    }

    public void rename(String aFilename) {
        File currentFile = new File(aFilename);
        File backupFile = new File(aFilename + ".prev");
        currentFile.renameTo(backupFile);
    }

    public static void printStats(ProcessTrace prT) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, "\n\t\t\t----------------------------------------");
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, "\t\t\t\t PERFORMANCE REPORT ");
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, "\t\t\t----------------------------------------\n");
        }
        List eveList = prT.getEvents();
        Checkpoint.printEveList(eveList, 0);
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, "_________________________________________________________________\n");
        }
    }

    public static void printEveList(List lst, int tCnt) {
        String tabS = "";
        int tabCnt = tCnt;
        for (int j = 0; j < tabCnt; ++j) {
            tabS = tabS + "\t";
        }
        for (int i = 0; i < lst.size(); ++i) {
            ProcessTraceEvent prEvent = (ProcessTraceEvent)lst.get(i);
            String compNameS = prEvent.getComponentName();
            String typeS = prEvent.getType();
            int dur = prEvent.getDurationExcludingSubEvents();
            int totDur = prEvent.getDuration();
            List subEveList = prEvent.getSubEvents();
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, tabS + "COMPONENT : " + compNameS + "\tTYPE : " + typeS + "\tDescription : " + prEvent.getDescription());
                UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, tabS + "TOTAL_TIME : " + totDur + "\tTIME_EXCLUDING_SUBEVENTS : " + dur);
            }
            if (subEveList != null) {
                Checkpoint.printEveList(subEveList, tabCnt + 1);
            }
            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
            UIMAFramework.getLogger(Checkpoint.class).log(Level.FINEST, " ");
        }
    }

    public boolean exists() {
        try {
            return new File(this.fileName).exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object restoreFromCheckpoint() throws IOException {
        ObjectInputStream stream = null;
        FileInputStream synchPointStream = null;
        try {
            File file = new File(this.fileName);
            Object anObject = null;
            if (file.exists()) {
                FileInputStream in;
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_restoring_from_checkpoint__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                if ((stream = new ObjectInputStream(in = new FileInputStream(file))) != null && (anObject = stream.readObject()) != null && anObject instanceof CheckpointData) {
                    ProcessTrace processTrace = ((CheckpointData)anObject).getProcessTrace();
                    Checkpoint.printStats(processTrace);
                }
            }
            file = new File(this.synchPointFileName);
            SynchPoint synchPoint = null;
            if (file.exists()) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_synchpoint_from_file__FINEST", new Object[]{Thread.currentThread().getName(), this.synchPointFileName});
                }
                if ((synchPointStream = new FileInputStream(file)) != null && anObject != null && anObject instanceof CheckpointData && (synchPoint = ((CheckpointData)anObject).getSynchPoint()) != null) {
                    synchPoint.deserialize((InputStream)synchPointStream);
                }
            }
            Object object = anObject;
            return object;
        }
        catch (EOFException file) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (synchPointStream != null) {
                synchPointStream.close();
            }
        }
        return null;
    }
}

