/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import org.apache.activemq.plugin.DefaultConfigurationProcessor;
import org.apache.activemq.plugin.RuntimeConfigurationBroker;
import org.apache.activemq.security.SimpleAuthenticationBroker;
import org.apache.activemq.security.SimpleAuthenticationPlugin;

public class SimpleAuthenticationPluginProcessor
extends DefaultConfigurationProcessor {
    public SimpleAuthenticationPluginProcessor(RuntimeConfigurationBroker plugin, Class configurationClass) {
        super(plugin, configurationClass);
    }

    @Override
    public void modify(Object existing, Object candidate) {
        try {
            final SimpleAuthenticationPlugin updatedPlugin = this.fromDto(candidate, new SimpleAuthenticationPlugin());
            final SimpleAuthenticationBroker authenticationBroker = (SimpleAuthenticationBroker)this.plugin.getBrokerService().getBroker().getAdaptor(SimpleAuthenticationBroker.class);
            this.plugin.addConnectionWork.add(new Runnable(){

                @Override
                public void run() {
                    authenticationBroker.setUserGroups(updatedPlugin.getUserGroups());
                    authenticationBroker.setUserPasswords(updatedPlugin.getUserPasswords());
                    authenticationBroker.setAnonymousAccessAllowed(updatedPlugin.isAnonymousAccessAllowed());
                    authenticationBroker.setAnonymousUser(updatedPlugin.getAnonymousUser());
                    authenticationBroker.setAnonymousGroup(updatedPlugin.getAnonymousGroup());
                }
            });
        }
        catch (Exception e) {
            this.plugin.info("failed to apply SimpleAuthenticationPlugin modifications to SimpleAuthenticationBroker", e);
        }
    }
}

