/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.message;

import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.Endpoint_impl;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.message.MessageContext;
import org.apache.uima.cas.SerialFormat;

public class JmsMessageContext
implements MessageContext {
    private static final Class CLASS_NAME = JmsMessageContext.class;
    private Message message;
    private Endpoint endpoint = new Endpoint_impl();
    private long messageArrivalTime = 0L;
    private String endpointName;

    public JmsMessageContext() {
    }

    public JmsMessageContext(Message aMessage, String anEndpointName) throws AsynchAEException {
        this();
        this.endpointName = anEndpointName;
        this.message = aMessage;
        try {
            if (aMessage instanceof BytesMessage) {
                this.endpoint.setSerialFormat(SerialFormat.BINARY);
            } else if (aMessage instanceof TextMessage) {
                this.endpoint.setSerialFormat(SerialFormat.XMI);
            }
            String msgFrom = aMessage.getStringProperty("MessageFrom");
            if (msgFrom != null) {
                this.endpoint.setEndpoint(msgFrom);
            }
            if (aMessage.getJMSReplyTo() != null) {
                this.endpoint.setDestination((Object)aMessage.getJMSReplyTo());
            }
            if (aMessage.propertyExists("ServerURI")) {
                this.endpoint.setServerURI(aMessage.getStringProperty("ServerURI"));
                this.endpoint.setRemote(!this.endpoint.getServerURI().startsWith("vm"));
            }
            if (aMessage.propertyExists("EndpointServer")) {
                this.endpoint.setRemote(true);
                this.endpoint.setEndpointServer(aMessage.getStringProperty("EndpointServer"));
            }
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public boolean propertyExists(String aKey) throws AsynchAEException {
        try {
            return this.message.propertyExists(aKey);
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Object getRawMessage() {
        return this.message;
    }

    public void setMessageArrivalTime(long anArrivalTime) {
        this.messageArrivalTime = anArrivalTime;
    }

    public long getMessageArrivalTime() {
        return this.messageArrivalTime;
    }

    public byte[] getByteMessage() throws AsynchAEException {
        try {
            if (this.message instanceof BytesMessage) {
                long payloadSize = ((BytesMessage)this.message).getBodyLength();
                byte[] payloadByteArray = new byte[(int)payloadSize];
                ((BytesMessage)this.message).readBytes(payloadByteArray);
                return payloadByteArray;
            }
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
        return new byte[0];
    }

    public int getMessageIntProperty(String aMessagePropertyName) throws AsynchAEException {
        try {
            return this.message.getIntProperty(aMessagePropertyName);
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
    }

    public long getMessageLongProperty(String aMessagePropertyName) throws AsynchAEException {
        try {
            return this.message.getLongProperty(aMessagePropertyName);
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
    }

    public Object getMessageObjectProperty(String aMessagePropertyName) throws AsynchAEException {
        try {
            return this.message.getObjectProperty(aMessagePropertyName);
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
    }

    public String getMessageStringProperty(String aMessagePropertyName) throws AsynchAEException {
        try {
            return this.message.getStringProperty(aMessagePropertyName);
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
    }

    public boolean getMessageBooleanProperty(String aMessagePropertyName) throws AsynchAEException {
        try {
            return this.message.getBooleanProperty(aMessagePropertyName);
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
    }

    public Object getObjectMessage() throws AsynchAEException {
        try {
            if (this.message instanceof ObjectMessage) {
                return ((ObjectMessage)this.message).getObject();
            }
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
        return null;
    }

    public String getStringMessage() throws AsynchAEException {
        try {
            if (this.message instanceof TextMessage) {
                return ((TextMessage)this.message).getText();
            }
        }
        catch (Exception e) {
            throw new AsynchAEException((Throwable)e);
        }
        return null;
    }
}

