/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.util.concurrent.CountDownLatch;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.error.AsynchAEException;

public class ControllerLatch {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AnalysisEngineController controller;

    public ControllerLatch(AnalysisEngineController aController) {
        this.controller = aController;
    }

    public void waitUntilInitialized() throws AsynchAEException {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new AsynchAEException(e);
        }
    }

    public void release() {
        this.latch.countDown();
    }

    public void openLatch(String aName, boolean isTopLevelAggregate, boolean showMsg) {
        this.release();
        if (!showMsg) {
            return;
        }
        System.out.println("Service:" + this.controller.getComponentName() + " Initialized. Ready To Process Messages From Queue:" + aName);
    }
}

