/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.delegate;

import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.LocalCache;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.ErrorContext;

public class ControllerDelegate
extends Delegate {
    private AnalysisEngineController controller;

    public ControllerDelegate(String aDelegateKey, AnalysisEngineController aController) {
        this.delegateKey = aDelegateKey;
        this.controller = aController;
    }

    @Override
    public String getComponentName() {
        return this.controller.getComponentName();
    }

    @Override
    public String enrichProcessCASTimeoutMessage(int aCommand, String casReferenceId, long timeToWait, String timeoutMessage) {
        StringBuffer sb = new StringBuffer(timeoutMessage);
        try {
            LocalCache.CasStateEntry cse;
            if (aCommand == 2000 && this.controller != null && casReferenceId != null && (cse = this.controller.getLocalCache().lookupEntry(casReferenceId)) != null && cse.getHostIpProcessingCAS() != null) {
                sb.append(". Process CAS on host: " + cse.getHostIpProcessingCAS() + " exceeded configured timeout threshold of " + timeToWait + " ms");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public void handleError(Exception e, ErrorContext errorContext) {
        if (this.controller != null && this.controller.getErrorHandlerChain() != null) {
            this.controller.getErrorHandlerChain().handle(e, errorContext, this.controller);
        }
    }
}

