/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resourceSpecifier.factory.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.resourceSpecifier.CasMultiplierType;
import org.apache.uima.resourceSpecifier.DelegateAnalysisEngineType;
import org.apache.uima.resourceSpecifier.DelegatesType;
import org.apache.uima.resourceSpecifier.RemoteAnalysisEngineType;
import org.apache.uima.resourceSpecifier.factory.AggregateDelegateEngine;
import org.apache.uima.resourceSpecifier.factory.ColocatedDelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.ColocatedDelegateEngine;
import org.apache.uima.resourceSpecifier.factory.DelegateAnalysisEngine;
import org.apache.uima.resourceSpecifier.factory.DelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.Delegates;
import org.apache.uima.resourceSpecifier.factory.RemoteDelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.RemoteDelegateEngine;
import org.apache.uima.resourceSpecifier.factory.ServiceContext;
import org.apache.uima.resourceSpecifier.factory.impl.AggregateDelegateEngineImpl;
import org.apache.uima.resourceSpecifier.factory.impl.ColocatedDelegateEngineImpl;
import org.apache.uima.resourceSpecifier.factory.impl.RemoteDelegateEngineImpl;
import org.springframework.util.Assert;

public class DelegatesImpl
implements Delegates {
    private DelegatesType dt;
    private AggregateDelegateEngine aggregateEngine;

    public DelegatesImpl(DelegatesType dt, AggregateDelegateEngine aggregateEngine, ServiceContext context, DelegateConfiguration ... delegateConfigurations) {
        this.dt = dt;
        if (delegateConfigurations != null) {
            this.aggregateEngine = aggregateEngine;
            List<DelegateConfiguration> delegateConfigurationList = Arrays.asList(delegateConfigurations);
            this.addDelegateEngine(aggregateEngine, delegateConfigurationList, dt, context);
        }
    }

    @Override
    public List<DelegateAnalysisEngine> getDelegates() {
        return this.aggregateEngine.getDelegates();
    }

    private void addCasMultiplier(CasMultiplierType cmt, DelegateConfiguration cdc) {
        cmt.setInitialFsHeapSize(String.valueOf(cdc.getInitialHeapSize()));
        cmt.setPoolSize(cdc.getCasPoolSize());
        cmt.setProcessParentLast(String.valueOf(cdc.processParentLast()));
    }

    private void addDelegateEngine(AggregateDelegateEngine containingAggregate, List<DelegateConfiguration> delegates, DelegatesType dt, ServiceContext context) {
        for (DelegateConfiguration delegate : delegates) {
            if (delegate.isRemote()) {
                RemoteAnalysisEngineType draet = dt.addNewRemoteAnalysisEngine();
                draet.setKey(delegate.getKey());
                containingAggregate.addDelegate(new RemoteDelegateEngineImpl(draet, (RemoteDelegateConfiguration)delegate, context));
                continue;
            }
            DelegateAnalysisEngineType dcaet = dt.addNewAnalysisEngine();
            dcaet.setKey(delegate.getKey());
            if (((ColocatedDelegateConfiguration)delegate).isAggregate()) {
                AggregateDelegateEngineImpl a1 = new AggregateDelegateEngineImpl(dcaet, delegate.getKey(), context, (ColocatedDelegateConfiguration)delegate);
                containingAggregate.addDelegate(a1);
                this.addDelegateEngine(a1, ((ColocatedDelegateConfiguration)delegate).getDelegates(), dcaet.addNewDelegates(), context);
                continue;
            }
            containingAggregate.addDelegate(new ColocatedDelegateEngineImpl(dcaet, (ColocatedDelegateConfiguration)delegate, context));
        }
    }

    @Override
    public void addDelegate(DelegateAnalysisEngine dae) {
        Assert.notNull((Object)dae);
        Assert.notNull((Object)this.dt);
        Assert.isTrue((dae instanceof RemoteDelegateEngine || dae instanceof ColocatedDelegateEngine ? 1 : 0) != 0, (String)("Invalid DelegateEngine Type. Expected either RemoteDelegateEngine or ColocatedDelegateEngine. Provided type is invalid:" + dae.getClass().getName()));
        this.aggregateEngine.addDelegate(dae);
    }

    @Override
    public List<RemoteDelegateEngine> getRemoteDelegates() {
        ArrayList<RemoteDelegateEngine> remoteDelegates = new ArrayList<RemoteDelegateEngine>();
        for (DelegateAnalysisEngine dea : this.aggregateEngine.getDelegates()) {
            if (!(dea instanceof RemoteDelegateEngine)) continue;
            remoteDelegates.add((RemoteDelegateEngine)dea);
        }
        return remoteDelegates;
    }

    @Override
    public List<ColocatedDelegateEngine> getColocatedDelegateEngine() {
        ArrayList<ColocatedDelegateEngine> colocatedDelegates = new ArrayList<ColocatedDelegateEngine>();
        for (DelegateAnalysisEngine dea : this.aggregateEngine.getDelegates()) {
            if (!(dea instanceof ColocatedDelegateEngine)) continue;
            colocatedDelegates.add((ColocatedDelegateEngine)dea);
        }
        return colocatedDelegates;
    }
}

