/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resourceSpecifier.factory.impl;

import org.apache.uima.resourceSpecifier.DeploymentType;
import org.apache.uima.resourceSpecifier.factory.CasPool;
import org.apache.uima.resourceSpecifier.factory.DelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.Deployment;
import org.apache.uima.resourceSpecifier.factory.Service;
import org.apache.uima.resourceSpecifier.factory.ServiceContext;
import org.apache.uima.resourceSpecifier.factory.impl.CasPoolImpl;
import org.apache.uima.resourceSpecifier.factory.impl.ServiceImpl;
import org.springframework.util.Assert;

public class DeploymentImpl
implements Deployment {
    private DeploymentType dt = null;
    private Service service = null;
    private CasPool casPool = null;

    protected DeploymentImpl(DeploymentType dt, ServiceContext context, DelegateConfiguration ... delegateConfigurations) {
        Assert.notNull((Object)dt);
        this.dt = dt;
        this.setProtocol(context.getProtocol());
        this.setProvider(context.getProvider());
        this.service = new ServiceImpl(dt.addNewService(), context, delegateConfigurations);
        this.casPool = new CasPoolImpl(dt.addNewCasPool(), context);
    }

    @Override
    public void setProtocol(String protocol) {
        Assert.notNull((Object)this.dt);
        this.dt.setProtocol(Deployment.VALID_PROTOCOLS.jms.name());
    }

    @Override
    public String getProtocol() {
        Assert.notNull((Object)this.dt);
        return this.dt.getProtocol();
    }

    @Override
    public void setProvider(String provider) {
        Assert.notNull((Object)this.dt);
        this.dt.setProvider(Deployment.VALID_PROVIDERS.activemq.name());
    }

    @Override
    public String getProvider() {
        Assert.notNull((Object)this.dt);
        return this.dt.getProvider();
    }

    @Override
    public Service getService() {
        Assert.notNull((Object)this.service);
        return this.service;
    }

    @Override
    public CasPool getCasPool() {
        Assert.notNull((Object)this.casPool);
        return this.casPool;
    }
}

