/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExtendedNodeInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrependIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.trans.XPathException;

public class IdrefTest
implements PatternFinder,
Serializable {
    private static IdrefTest THE_INSTANCE = new IdrefTest();

    public static IdrefTest getInstance() {
        return THE_INSTANCE;
    }

    private IdrefTest() {
    }

    public SequenceIterator selectNodes(DocumentInfo documentInfo, XPathContext xPathContext) throws XPathException {
        AxisIterator axisIterator = documentInfo.iterateAxis((byte)4, NodeKindTest.ELEMENT);
        MappingFunction mappingFunction = new MappingFunction(){

            public SequenceIterator map(Item item) {
                return new PrependIterator((NodeInfo)item, ((NodeInfo)item).iterateAxis((byte)2));
            }
        };
        MappingIterator mappingIterator = new MappingIterator(axisIterator, mappingFunction);
        ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

            public Item map(Item item) {
                if (IdrefTest.this.matches((NodeInfo)item)) {
                    return item;
                }
                return null;
            }
        };
        return new ItemMappingIterator(mappingIterator, itemMappingFunction);
    }

    private boolean matches(NodeInfo nodeInfo) {
        if (nodeInfo instanceof ExtendedNodeInfo) {
            return ((ExtendedNodeInfo)nodeInfo).isIdref();
        }
        return false;
    }

    public String toString() {
        return "is-idref()";
    }
}

