/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;

public class StandardModuleURIResolver
implements ModuleURIResolver {
    private Configuration config;

    public StandardModuleURIResolver(Configuration configuration) {
        this.config = configuration;
    }

    public StreamSource[] resolve(String string, String string2, String[] stringArray) throws XPathException {
        if (stringArray.length == 0) {
            StaticError staticError = new StaticError("Cannot locate module for namespace " + string);
            staticError.setErrorCode("XQST0059");
            throw staticError;
        }
        Platform platform = Configuration.getPlatform();
        StreamSource[] streamSourceArray = new StreamSource[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            URI uRI;
            String string3 = stringArray[i];
            try {
                uRI = platform.makeAbsolute(string3, string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                StaticError staticError = new StaticError("Cannot resolve relative URI " + string3, uRISyntaxException);
                staticError.setErrorCode("XQST0059");
                throw staticError;
            }
            streamSourceArray[i] = StandardModuleURIResolver.getQuerySource(uRI);
        }
        return streamSourceArray;
    }

    private static StreamSource getQuerySource(URI uRI) throws StaticError {
        try {
            int n;
            String string;
            URL uRL = uRI.toURL();
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            String string2 = null;
            if (!"file".equals(uRLConnection.getURL().getProtocol()) && (string = uRLConnection.getContentType()) != null && (n = string.indexOf("charset")) >= 0) {
                if ((n = string.indexOf(61, n + 7)) >= 0) {
                    string = string.substring(n + 1);
                }
                if ((n = string.indexOf(59)) > 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(40)) > 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(34)) > 0) {
                    string = string.substring(n + 1, string.indexOf(34, n + 2));
                }
                string2 = string.trim();
            }
            StreamSource streamSource = new StreamSource();
            if (string2 == null) {
                streamSource.setInputStream(inputStream);
            } else {
                streamSource.setReader(new InputStreamReader(inputStream, string2));
            }
            streamSource.setSystemId(uRL.toString());
            return streamSource;
        }
        catch (IOException iOException) {
            StaticError staticError = new StaticError(iOException);
            staticError.setErrorCode("XQST0059");
            throw staticError;
        }
    }
}

