/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import net.sf.saxon.Err;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.regex.RegexData;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.value.Whitespace;

public abstract class RegexTranslator {
    protected CharSequence regExp;
    protected boolean isXPath;
    protected boolean ignoreWhitespace;
    protected boolean inCharClassExpr;
    protected boolean caseBlind;
    protected int pos = 0;
    protected int length;
    protected char curChar;
    protected boolean eos = false;
    protected int currentCapture = 0;
    protected IntHashSet captures = new IntHashSet();
    protected final FastStringBuffer result = new FastStringBuffer(32);
    public static final int NONE = -1;
    public static final int SOME = 0;
    public static final int ALL = 1;
    public static final String SURROGATES1_CLASS = "[\ud800-\udbff]";
    public static final String SURROGATES2_CLASS = "[\udc00-\udfff]";
    public static final String NOT_ALLOWED_CLASS = "[\u0000&&[^\u0000]]";

    protected void translateTop() throws RegexSyntaxException {
        this.translateRegExp();
        if (!this.eos) {
            throw this.makeException("expected end of string");
        }
    }

    protected void translateRegExp() throws RegexSyntaxException {
        this.translateBranch();
        while (this.curChar == '|') {
            this.copyCurChar();
            this.translateBranch();
        }
    }

    protected void translateBranch() throws RegexSyntaxException {
        while (this.translateAtom()) {
            this.translateQuantifier();
        }
    }

    protected abstract boolean translateAtom() throws RegexSyntaxException;

    protected void translateQuantifier() throws RegexSyntaxException {
        switch (this.curChar) {
            case '*': 
            case '+': 
            case '?': {
                this.copyCurChar();
                break;
            }
            case '{': {
                this.copyCurChar();
                this.translateQuantity();
                this.expect('}');
                this.copyCurChar();
                break;
            }
            default: {
                return;
            }
        }
        if (this.curChar == '?' && this.isXPath) {
            this.copyCurChar();
        }
    }

    protected void translateQuantity() throws RegexSyntaxException {
        block7: {
            String string = ((Object)this.parseQuantExact()).toString();
            int n = -1;
            try {
                n = Integer.parseInt(string);
                this.result.append(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.result.append("2147483647");
            }
            if (this.curChar == ',') {
                this.copyCurChar();
                if (this.curChar != '}') {
                    String string2 = ((Object)this.parseQuantExact()).toString();
                    try {
                        int n2 = Integer.parseInt(string2);
                        this.result.append(string2);
                        if (n < 0 || n2 < n) {
                            throw this.makeException("invalid range in quantifier");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.result.append("2147483647");
                        if (n >= 0 || new BigDecimal(string).compareTo(new BigDecimal(string2)) <= 0) break block7;
                        throw this.makeException("invalid range in quantifier");
                    }
                }
            }
        }
    }

    protected CharSequence parseQuantExact() throws RegexSyntaxException {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(10);
        do {
            if ("0123456789".indexOf(this.curChar) < 0) {
                throw this.makeException("expected digit in quantifier");
            }
            fastStringBuffer.append(this.curChar);
            this.advance();
        } while (this.curChar != ',' && this.curChar != '}');
        return fastStringBuffer;
    }

    protected void copyCurChar() {
        this.result.append(this.curChar);
        this.advance();
    }

    protected void advance() {
        if (this.pos < this.length) {
            this.curChar = this.regExp.charAt(this.pos++);
            if (this.ignoreWhitespace && !this.inCharClassExpr) {
                while (Whitespace.isWhitespace(this.curChar)) {
                    this.advance();
                }
            }
        } else {
            ++this.pos;
            this.curChar = '\u0000';
            this.eos = true;
        }
    }

    protected int absorbSurrogatePair() throws RegexSyntaxException {
        if (XMLChar.isSurrogate(this.curChar)) {
            if (!XMLChar.isHighSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            char c = this.curChar;
            this.advance();
            if (!XMLChar.isLowSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            return XMLChar.supplemental(c, this.curChar);
        }
        return this.curChar;
    }

    protected void recede() {
        if (this.eos) {
            this.curChar = this.regExp.charAt(this.length - 1);
            this.pos = this.length;
            this.eos = false;
        } else {
            this.curChar = this.regExp.charAt(--this.pos - 1);
        }
        if (this.ignoreWhitespace && !this.inCharClassExpr) {
            while (Whitespace.isWhitespace(this.curChar)) {
                this.recede();
            }
        }
    }

    protected void expect(char c) throws RegexSyntaxException {
        if (this.curChar != c) {
            throw this.makeException("expected", new String(new char[]{c}));
        }
    }

    protected RegexSyntaxException makeException(String string) {
        return new RegexSyntaxException("Error at character " + (this.pos - 1) + " in regular expression " + Err.wrap(this.regExp, 4) + ": " + string);
    }

    protected RegexSyntaxException makeException(String string, String string2) {
        return new RegexSyntaxException("Error at character " + (this.pos - 1) + " in regular expression " + Err.wrap(this.regExp, 4) + ": " + string + " (" + string2 + ')');
    }

    protected static boolean isJavaMetaChar(int n) {
        switch (n) {
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    protected static String highSurrogateRanges(List list) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(list.size() * 2);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Range range = (Range)list.get(i);
            char c = XMLChar.highSurrogate(range.getMin());
            char c2 = XMLChar.lowSurrogate(range.getMin());
            char c3 = XMLChar.highSurrogate(range.getMax());
            char c4 = XMLChar.lowSurrogate(range.getMax());
            if (c2 != '\udc00') {
                c = (char)(c + '\u0001');
            }
            if (c4 != '\udfff') {
                c3 = (char)(c3 - '\u0001');
            }
            if (c3 < c) continue;
            fastStringBuffer.append(c);
            fastStringBuffer.append(c3);
        }
        return fastStringBuffer.toString();
    }

    protected static String lowSurrogateRanges(List list) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(list.size() * 2);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Range range = (Range)list.get(i);
            char c = XMLChar.highSurrogate(range.getMin());
            char c2 = XMLChar.lowSurrogate(range.getMin());
            char c3 = XMLChar.highSurrogate(range.getMax());
            char c4 = XMLChar.lowSurrogate(range.getMax());
            if (c == c3) {
                if (c2 == '\udc00' && c4 == '\udfff') continue;
                fastStringBuffer.append(c);
                fastStringBuffer.append(c2);
                fastStringBuffer.append(c4);
                continue;
            }
            if (c2 != '\udc00') {
                fastStringBuffer.append(c);
                fastStringBuffer.append(c2);
                fastStringBuffer.append('\udfff');
            }
            if (c4 == '\udfff') continue;
            fastStringBuffer.append(c3);
            fastStringBuffer.append('\udc00');
            fastStringBuffer.append(c4);
        }
        return fastStringBuffer.toString();
    }

    protected static void sortRangeList(List list) {
        Collections.sort(list);
        int n = 0;
        int n2 = 0;
        int n3 = list.size();
        while (n2 < n3) {
            Range range;
            Range range2 = (Range)list.get(n2);
            int n4 = range2.getMin();
            int n5 = range2.getMax();
            while (++n2 < n3 && (range = (Range)list.get(n2)).getMin() <= n5 + 1) {
                if (range.getMax() <= n5) continue;
                n5 = range.getMax();
            }
            if (n5 != range2.getMax()) {
                range2 = new Range(n4, n5);
            }
            list.set(n++, range2);
        }
        while (n3 > n) {
            list.remove(--n3);
        }
    }

    protected static boolean isBlock(String string) {
        for (int i = 0; i < RegexData.blockNames.length; ++i) {
            if (!string.equals(RegexData.blockNames[i])) continue;
            return true;
        }
        return false;
    }

    protected static boolean isAsciiAlnum(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    public static final class Range
    implements Comparable {
        private final int min;
        private final int max;

        public Range(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int compareTo(Object object) {
            Range range = (Range)object;
            if (this.min < range.min) {
                return -1;
            }
            if (this.min > range.min) {
                return 1;
            }
            if (this.max > range.max) {
                return -1;
            }
            if (this.max < range.max) {
                return 1;
            }
            return 0;
        }
    }
}

